
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
INSERT INTO `account_transactions` VALUES (6,7,'credit','opening_balance',1000.0000,NULL,'2018-11-26 13:26:13',13,NULL,NULL,NULL,NULL,NULL,'2018-11-26 07:56:13','2018-11-26 07:56:13'),(8,7,'debit','fund_transfer',1000.0000,NULL,'2018-11-26 13:53:00',13,NULL,NULL,9,'sdsd',NULL,'2018-11-26 08:24:02','2018-11-26 08:24:02'),(9,6,'credit','fund_transfer',1000.0000,NULL,'2018-11-26 13:53:00',13,NULL,NULL,8,'sdsd',NULL,'2018-11-26 08:24:02','2018-11-26 08:24:02'),(10,8,'credit','opening_balance',10.0000,NULL,'2018-12-12 01:04:33',1,NULL,NULL,NULL,NULL,NULL,'2018-12-11 19:34:33','2018-12-11 19:34:33');
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_type` enum('saving_current','capital') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (5,1,'Nikhil','12345','saving_current',NULL,1,1,NULL,'2018-11-25 19:21:52','2018-12-11 19:35:32'),(6,7,'Nikhil','123456','saving_current',NULL,13,1,NULL,'2018-11-26 07:55:03','2018-11-26 08:25:27'),(7,7,'capital A/C','4567','capital',NULL,13,0,NULL,'2018-11-26 07:56:13','2018-11-26 07:56:13'),(8,1,'TEST','test12345qwer','capital','test',1,0,NULL,'2018-12-11 19:34:30','2018-12-11 19:34:30');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `paper_width` double(8,2) DEFAULT NULL,
  `paper_height` double(8,2) DEFAULT NULL,
  `top_margin` double(8,2) DEFAULT NULL,
  `left_margin` double(8,2) DEFAULT NULL,
  `row_distance` double(8,2) DEFAULT NULL,
  `col_distance` double(8,2) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 4\" x 1\"\\r\\nLabels per sheet: 20',3.75,1.00,8.50,11.00,0.50,0.50,0.00,0.16,2,0,0,20,NULL,'2017-12-18 00:43:44','2017-12-18 00:43:44'),(2,'30 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2.625\" x 1\"\\r\\nLabels per sheet: 30',2.62,1.00,8.50,11.00,0.50,0.22,0.00,0.14,3,0,0,30,NULL,'2017-12-18 00:34:39','2017-12-18 00:40:40'),(3,'32 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1.25\"\\r\\nLabels per sheet: 32',2.00,1.25,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,32,NULL,'2017-12-18 00:25:40','2017-12-18 00:25:40'),(4,'40 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1\"\\r\\nLabels per sheet: 40',2.00,1.00,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,40,NULL,'2017-12-18 00:28:40','2017-12-18 00:28:40'),(5,'50 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 1.5\" x 1\"\\r\\nLabels per sheet: 50',1.50,1.00,8.50,11.00,0.50,0.50,0.00,0.00,5,0,0,50,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm\\r\\nGap: 3.18mm',1.25,1.00,1.25,0.00,0.12,0.00,0.12,0.00,1,0,1,NULL,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` enum('booked','completed','cancelled') COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
INSERT INTO `bookings` VALUES (1,1,NULL,NULL,1,1,1,'2018-11-15 12:28:00','2018-11-15 12:29:00',1,'booked',NULL,'2018-11-14 18:29:21','2018-11-14 18:29:21');
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Levis',NULL,1,NULL,'2018-01-03 15:49:47','2018-01-03 15:49:47'),(2,1,'Espirit',NULL,1,NULL,'2018-01-03 15:49:58','2018-01-03 15:49:58'),(3,1,'U.S. Polo Assn.',NULL,1,NULL,'2018-01-03 15:50:26','2018-01-03 15:50:26'),(4,1,'Nike',NULL,1,NULL,'2018-01-03 15:50:34','2018-01-03 15:50:34'),(5,1,'Puma',NULL,1,NULL,'2018-01-03 15:50:40','2018-01-03 15:50:40'),(6,1,'Adidas',NULL,1,NULL,'2018-01-03 15:50:46','2018-01-03 15:50:46'),(7,1,'Samsung',NULL,1,NULL,'2018-01-06 00:10:14','2018-01-06 00:10:14'),(8,1,'Apple',NULL,1,NULL,'2018-01-06 00:10:23','2018-01-06 00:10:23'),(9,1,'Acer',NULL,1,NULL,'2018-01-06 00:33:37','2018-01-06 00:33:37'),(10,1,'Bowflex',NULL,1,NULL,'2018-01-06 00:45:31','2018-01-06 00:45:31'),(11,1,'Oreo',NULL,1,NULL,'2018-01-06 01:05:00','2018-01-06 01:05:00'),(12,1,'Sharewood',NULL,1,NULL,'2018-01-06 01:10:52','2018-01-06 01:10:52'),(13,1,'Barilla',NULL,1,NULL,'2018-01-06 01:14:59','2018-01-06 01:14:59'),(14,1,'Lipton',NULL,1,NULL,'2018-01-06 01:18:12','2018-01-06 01:18:12'),(15,2,'Acino',NULL,4,NULL,'2018-04-10 02:44:44','2018-04-10 02:44:44'),(16,2,'Cipla',NULL,4,NULL,'2018-04-10 02:45:04','2018-04-10 02:45:04'),(17,2,'BAYER',NULL,4,NULL,'2018-04-10 02:45:32','2018-04-10 02:45:32'),(24,1,'n1',NULL,1,NULL,'2018-11-12 03:58:23','2018-11-12 03:58:23'),(25,1,'test','Toothpaste edited',1,NULL,'2018-11-14 23:29:54','2018-11-14 23:29:54'),(26,1,'test','Toothpaste edited',1,NULL,'2018-11-14 23:29:55','2018-11-14 23:29:55'),(27,1,'test','Toothpaste edited',1,NULL,'2018-11-14 23:29:55','2018-11-14 23:29:55'),(28,1,'brand 1','brand 1',1,NULL,'2018-11-15 00:52:57','2018-11-15 00:52:57'),(29,1,'brand 1','brand 1',1,NULL,'2018-11-15 00:52:57','2018-11-15 00:52:57'),(33,1,'simple brand',NULL,1,NULL,'2018-12-06 19:30:32','2018-12-06 19:30:32');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(20,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `woocommerce_api_settings` text COLLATE utf8mb4_unicode_ci,
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `email_settings` text COLLATE utf8mb4_unicode_ci,
  `sms_settings` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Awesome Shop',53,'2018-01-01','3412569900','GSTIN',NULL,NULL,NULL,25.00,1,'America/Phoenix',1,'fifo',10.00,'includes',NULL,'AS',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"is_pos_subtotal_editable\":\"1\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0}',NULL,1,1,1,1,1,0,NULL,0,0,0,1,'cmsn_agnt',1,1,'before','[\"tables\",\"modifiers\",\"service_staff\",\"kitchen\",\"account\"]','d/m/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":null,\"stock_adjustment\":null,\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":null}','purple-light',NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"admin\",\"mail_password\":\"123456\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-01-03 20:45:19','2018-12-13 00:37:00'),(2,'Awesome Pharmacy',2,'2018-04-10','3412569900','VAT',NULL,NULL,NULL,25.00,4,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AP',1,'add_manufacturing','stop_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,4,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-04-10 02:42:40','2018-11-18 07:03:08'),(4,'Awesome Services',124,NULL,'3412569900','GST',NULL,NULL,NULL,25.00,6,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AS',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,0,1,0,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-04-10 06:50:42','2018-04-10 06:53:40'),(5,'Awesome Restaurant',2,'2018-07-12','4578220005','IGST','4593220009','SGST',NULL,25.00,7,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AR',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0}',NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before','[\"tables\",\"modifiers\",\"service_staff\",\"kitchen\"]','m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-07-13 11:12:11','2018-11-18 07:03:37'),(6,'Pesapal',133,'2018-11-23',NULL,NULL,NULL,NULL,NULL,25.00,12,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}',NULL,NULL,'{\"mail_driver\":\"sendmail\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"admin\",\"mail_password\":\"123456\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-11-23 10:35:47','2018-11-23 10:53:03'),(7,'account',53,'2018-11-26',NULL,NULL,NULL,NULL,NULL,25.00,13,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before','[\"account\"]','m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"admin\",\"mail_password\":\"123456\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-11-26 07:53:58','2018-11-26 08:12:35'),(8,'Bname',53,'2018-11-28',NULL,NULL,NULL,NULL,NULL,25.00,14,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-11-28 06:31:01','2018-11-28 06:31:01'),(9,'Woocommerce',53,'2018-11-30',NULL,NULL,NULL,NULL,NULL,25.00,15,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,'{\"woocommerce_app_url\":\"http:\\/\\/localhost\\/twf-projects\\/pos-wordpress\\/\",\"woocommerce_consumer_key\":\"ck_c6973a7222ebddd91c41808a2fdb964c50738cab\",\"woocommerce_consumer_secret\":\"cs_48f0c3aa89858a1cef6c45a4ef94a1651b7345d4\",\"location_id\":\"9\",\"default_tax_class\":null,\"product_tax_type\":\"inc\",\"default_selling_price_group\":null,\"product_fields_for_create\":[\"category\",\"quantity\"],\"product_fields_for_update\":[\"name\",\"price\",\"category\",\"quantity\"]}',1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-11-30 07:55:34','2018-11-30 07:58:36'),(10,'test',3,'2018-11-30',NULL,NULL,NULL,NULL,NULL,25.00,16,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-11-30 13:37:26','2018-11-30 13:37:26'),(11,'Business Nam',53,'2018-12-11',NULL,NULL,NULL,NULL,NULL,25.00,17,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(12,'test',52,'2018-12-12',NULL,NULL,NULL,NULL,NULL,25.00,18,'Africa/Algiers',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-12-12 06:20:43','2018-12-12 06:20:43');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,NULL,'Awesome Shop 1','Linking Street_e','USA_e','Arizona_e','Phoenix_e','85001_e',1,1,1,'browser',NULL,'9437638555_e','9437638000_e','testee@test.com','http://local.pos.com/business-location',NULL,NULL,NULL,NULL,NULL,'2018-01-03 20:45:20','2018-12-10 19:17:45'),(2,2,NULL,'Awesome Pharmacy','Linking Street','USA','Arizona','Phoenix','492001',2,2,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(4,4,NULL,'Awesome Services','Linking Street','USA','Arizona','Phoenix','282001',4,4,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(5,5,NULL,'Awesome Restaurant','Linking Street','USA','Arizona','Phoenix','85001',5,5,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-07-13 05:42:11','2018-07-13 05:42:11'),(6,6,'BL0001','Pesapal','Pesapal','Pesapal','Pesapal','Pesapal','Pesapal',6,6,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(7,7,'BL0001','account','Road No.2','India','Odisha','Kbj','767039',7,7,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(8,8,'BL0001','Bname','test','etst','tets','tetst','etst',8,8,1,'browser',NULL,'9437638555','934','','',NULL,NULL,NULL,NULL,NULL,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(9,9,'BL0001','Woocommerce','t','t','t','t','t',9,9,1,'browser',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(10,10,'BL0001','test','t','t','t','t','t',10,10,1,'browser',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(11,11,'BL0001','Business Nam','Landmark:','Country:','State:','City:','Zip Cod',11,11,1,'browser',NULL,'Business contact number:','Alternate contact number:','','http://local.pos.com/business-location',NULL,NULL,NULL,NULL,NULL,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(12,12,'BL0001','test','t','tetst','test','tt','t',12,12,1,'browser',NULL,'test','test','','test',NULL,NULL,NULL,NULL,NULL,'2018-12-12 06:20:45','2018-12-12 06:20:45');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `pay_method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,0.00,'cash','credit','initial',NULL,'2018-07-13 02:09:34','2018-07-13 02:09:34'),(2,1,42.50,'cash','credit','sell',41,'2018-07-13 02:14:40','2018-07-13 02:14:40'),(3,1,0.00,'cash','credit','sell',41,'2018-07-13 02:14:40','2018-07-13 02:14:40'),(4,1,77.50,'cash','credit','sell',42,'2018-07-13 02:15:29','2018-07-13 02:15:29'),(5,1,0.00,'cash','credit','sell',42,'2018-07-13 02:15:29','2018-07-13 02:15:29'),(6,1,33.75,'cash','credit','sell',43,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(7,1,0.00,'cash','credit','sell',43,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(8,1,71.25,'cash','credit','sell',44,'2018-07-13 02:16:36','2018-07-13 02:16:36'),(9,1,0.00,'cash','credit','sell',44,'2018-07-13 02:16:36','2018-07-13 02:16:36'),(10,2,0.00,'cash','credit','initial',NULL,'2018-11-23 10:46:09','2018-11-23 10:46:09'),(11,3,0.00,'cash','credit','initial',NULL,'2018-11-25 22:32:31','2018-11-25 22:32:31'),(12,3,71.28,'cash','credit','sell',49,'2018-11-27 17:28:07','2018-11-27 17:28:07'),(13,3,0.00,'cash','credit','sell',49,'2018-11-27 17:28:07','2018-11-27 17:28:07'),(14,3,121.28,'cash','credit','sell',54,'2018-11-27 17:58:01','2018-11-27 17:58:01'),(15,3,0.00,'cash','credit','sell',54,'2018-11-27 17:58:01','2018-11-27 17:58:01'),(16,3,71.28,'cash','credit','sell',55,'2018-11-27 17:58:11','2018-11-27 17:58:11'),(17,3,0.00,'cash','credit','sell',55,'2018-11-27 17:58:11','2018-11-27 17:58:11'),(18,3,8680.50,'card','credit','sell',57,'2018-11-29 00:01:06','2018-11-29 00:01:06'),(19,3,0.00,'cash','credit','sell',57,'2018-11-29 00:01:06','2018-11-29 00:01:06'),(20,3,112.50,'cash','credit','sell',65,'2018-12-03 22:08:29','2018-12-03 22:08:29'),(21,3,0.00,'cash','credit','sell',65,'2018-12-03 22:08:30','2018-12-03 22:08:30'),(22,3,500.00,'cash','credit','sell',69,'2018-12-13 00:32:45','2018-12-13 00:32:45'),(23,3,0.00,'cash','credit','sell',69,'2018-12-13 00:32:46','2018-12-13 00:32:46'),(24,3,200.00,'cash','credit','sell',70,'2018-12-13 00:33:30','2018-12-13 00:33:30'),(25,3,0.00,'cash','credit','sell',70,'2018-12-13 00:33:30','2018-12-13 00:33:30');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,5,7,'open',NULL,0.00,0,0,NULL,'2018-07-13 02:09:34','2018-07-13 02:09:34'),(2,6,12,'open',NULL,0.00,0,0,NULL,'2018-11-23 10:46:09','2018-11-23 10:46:09'),(3,1,1,'open',NULL,0.00,0,0,NULL,'2018-11-25 22:32:31','2018-11-25 22:32:31');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_cat_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Men\'s',1,NULL,0,1,NULL,NULL,'2018-01-03 15:36:34','2018-01-03 15:36:34'),(2,'Women\'s',1,NULL,0,1,NULL,NULL,'2018-01-03 15:36:46','2018-01-03 15:36:46'),(3,'Accessories',1,NULL,0,1,NULL,NULL,'2018-01-03 15:37:03','2018-01-03 15:37:03'),(4,'Jeans',1,NULL,1,1,NULL,NULL,'2018-01-03 15:37:34','2018-01-03 15:37:34'),(5,'Shirts',1,NULL,1,1,NULL,NULL,'2018-01-03 15:38:18','2018-01-03 15:38:18'),(6,'Belts',1,NULL,3,1,NULL,NULL,'2018-01-03 15:38:41','2018-01-03 15:38:41'),(8,'Shoes',1,NULL,3,1,NULL,NULL,'2018-01-03 15:39:04','2018-01-03 15:39:04'),(10,'Sandal',1,NULL,3,1,NULL,NULL,'2018-01-03 15:39:23','2018-01-03 15:39:23'),(11,'Wallets',1,NULL,3,1,NULL,NULL,'2018-01-03 17:35:50','2018-01-03 17:35:50'),(12,'Electronics',1,NULL,0,1,NULL,NULL,'2018-01-05 23:54:34','2018-01-05 23:54:34'),(13,'Cell Phones',1,NULL,12,1,NULL,NULL,'2018-01-05 23:54:57','2018-01-05 23:54:57'),(14,'Computers',1,NULL,12,1,NULL,NULL,'2018-01-05 23:55:55','2018-01-05 23:55:55'),(15,'Sports',1,NULL,0,1,NULL,NULL,'2018-01-05 23:57:33','2018-01-05 23:57:33'),(16,'Athletic Clothing',1,NULL,15,1,NULL,NULL,'2018-01-05 23:58:40','2018-01-05 23:58:40'),(17,'Exercise & Fitness',1,NULL,15,1,NULL,NULL,'2018-01-05 23:59:19','2018-01-05 23:59:19'),(18,'Books',1,NULL,0,1,NULL,NULL,'2018-01-05 23:59:59','2018-01-05 23:59:59'),(19,'Autobiography',1,NULL,18,1,NULL,NULL,'2018-01-06 00:00:16','2018-01-06 00:00:16'),(20,'Children\'s books',1,NULL,18,1,NULL,NULL,'2018-01-06 00:00:58','2018-01-06 00:00:58'),(21,'Food & Grocery',1,NULL,0,1,NULL,NULL,'2018-01-06 00:01:35','2018-01-06 00:01:35'),(22,'Capsule',2,NULL,0,4,NULL,NULL,'2018-04-10 02:49:58','2018-04-10 02:50:54'),(23,'Bandages',2,NULL,0,4,NULL,NULL,'2018-04-10 02:50:48','2018-04-10 02:50:48'),(24,'Cream',2,NULL,0,4,NULL,NULL,'2018-04-10 02:51:23','2018-04-10 02:51:23'),(25,'Drops',2,NULL,0,4,NULL,NULL,'2018-04-10 02:51:31','2018-04-10 02:51:31'),(26,'Gel',2,NULL,0,4,NULL,NULL,'2018-04-10 02:51:57','2018-04-10 02:51:57'),(27,'Bottle',2,NULL,0,4,NULL,NULL,'2018-04-10 02:52:30','2018-04-10 02:52:30'),(34,'Car Services',4,NULL,0,6,NULL,NULL,'2018-04-10 06:55:33','2018-04-10 07:00:10'),(35,'Hair Styling',4,NULL,0,6,NULL,NULL,'2018-04-10 06:58:32','2018-04-10 06:59:18'),(36,'Plumbing',4,NULL,0,6,NULL,NULL,'2018-04-10 07:00:41','2018-04-10 07:00:41'),(37,'Bodycare',4,NULL,0,6,NULL,NULL,'2018-04-10 07:00:52','2018-04-10 07:00:52'),(38,'Spa',4,NULL,0,6,NULL,NULL,'2018-04-10 07:01:01','2018-04-10 07:01:01'),(39,'Starter',5,NULL,0,7,NULL,NULL,'2018-07-12 19:19:08','2018-07-12 19:19:08'),(40,'Main Menu',5,NULL,0,7,NULL,NULL,'2018-07-12 19:19:24','2018-07-12 19:19:24'),(41,'Salad',5,NULL,0,7,NULL,NULL,'2018-07-12 19:20:15','2018-07-12 19:20:15'),(42,'Pizza',5,NULL,0,7,NULL,NULL,'2018-07-12 19:20:29','2018-07-12 19:20:29'),(43,'Desserts',5,NULL,0,7,NULL,NULL,'2018-07-12 19:20:40','2018-07-12 19:20:40'),(44,'Drinks',5,NULL,0,7,NULL,NULL,'2018-07-12 19:20:54','2018-07-12 19:20:54'),(45,'Bakery and Snacks',5,NULL,0,7,NULL,NULL,'2018-07-12 20:28:40','2018-07-12 20:28:40'),(240,'BEEF ITEMS',1,NULL,0,1,NULL,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(241,'MUTTON ITEMS',1,NULL,0,1,NULL,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(242,'NORTH INDIAN VEG',1,NULL,0,1,NULL,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(243,'NORTH INDIAN CHICKEN ITEMS',1,NULL,0,1,NULL,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(244,'NORTH INDIAN MUTTON ITEMS',1,NULL,0,1,NULL,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(245,'SOUPS',1,NULL,0,1,NULL,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(252,'FRIED RICE & NOODLES',1,NULL,0,1,NULL,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(253,'SCHEZWAN',1,NULL,0,1,NULL,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(254,'CHINESE CURRY',1,NULL,0,1,NULL,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(258,'THANDOORI',1,NULL,0,1,NULL,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(259,'MAJAS SPECIAL',1,NULL,0,1,NULL,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(261,'JUICES',1,NULL,0,1,NULL,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(268,'CATEGORY',1,NULL,0,1,NULL,NULL,'2018-12-06 19:30:32','2018-12-06 19:30:32'),(269,'subcat',1,NULL,268,1,NULL,NULL,'2018-12-06 19:30:32','2018-12-06 19:30:32');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('supplier','customer','both') COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landmark` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(20,2) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,'CO0005',NULL,'Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:15:20','2018-06-11 16:52:05'),(2,1,'supplier','Alpha Clothings','Michael',NULL,'CO0001','4590091535','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,15,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:29:38','2018-06-11 16:51:03'),(3,1,'supplier','Manhattan Clothing Ltd.','Philip',NULL,'CO0003','54869310093','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,15,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:30:55','2018-06-11 16:51:36'),(4,1,'customer',NULL,'Harry',NULL,'CO0006',NULL,'Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:31:40','2018-06-11 16:52:16'),(5,1,'supplier','Digital Ocean','Mike McCubbin',NULL,'CN0004','52965489001','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,30,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:23:22','2018-06-11 16:51:47'),(6,1,'supplier','Univer Suppliers','Jackson Hill',NULL,'CO0002','5459000655','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,45,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:25:09','2018-06-11 16:51:18'),(7,2,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(8,2,'supplier','Jones Pharma','Micheal Larson',NULL,'522500003',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',NULL,4,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:32:52','2018-04-10 04:32:52'),(9,2,'supplier','Axolotl Biologix','Phillip Jenner',NULL,'4585220005',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',NULL,4,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:34:20','2018-04-10 04:34:20'),(13,4,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(14,5,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,7,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-07-13 11:12:11','2018-07-13 11:12:11'),(15,5,'supplier','Perfect Bakers','Thomas Willson','thomas@example.com','CO0002','45781005',NULL,NULL,NULL,NULL,'87850009358',NULL,NULL,10,'months',NULL,7,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-07-13 02:03:50','2018-07-13 02:03:50'),(16,1,'supplier','test','test',NULL,'CO0007',NULL,NULL,NULL,NULL,NULL,'9437638555',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-15 01:06:27','2018-11-15 01:06:27'),(17,6,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,12,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(18,7,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,13,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-26 07:53:58','2018-11-26 07:53:58'),(19,7,'supplier','Bnam','Nikhil',NULL,'CO0002',NULL,NULL,NULL,NULL,NULL,'9437638555',NULL,NULL,NULL,NULL,NULL,13,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-26 08:07:50','2018-11-26 08:07:50'),(20,8,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,14,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-28 06:31:01','2018-11-28 06:31:01'),(21,9,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,15,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(22,10,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,16,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(23,1,'supplier','new suppliee','new suppliee',NULL,'CO0008',NULL,NULL,NULL,NULL,NULL,'test',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-12-06 00:31:00','2018-12-06 00:31:00'),(24,11,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,17,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(25,12,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,18,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-12-12 06:20:44','2018-12-12 06:20:44');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHC','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MX','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NG','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_document_shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_document_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(11) NOT NULL,
  `value_type` enum('user','role') COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_document_shares` WRITE;
/*!40000 ALTER TABLE `essentials_document_shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_document_shares` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_documents` WRITE;
/*!40000 ALTER TABLE `essentials_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_documents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `repeat` enum('one_time','every_day','every_week','every_month') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_reminders` WRITE;
/*!40000 ALTER TABLE `essentials_reminders` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_reminders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_to_dos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_to_dos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `task` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `is_completed` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_to_dos` WRITE;
/*!40000 ALTER TABLE `essentials_to_dos` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_to_dos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
INSERT INTO `group_sub_taxes` VALUES (4,2),(4,3);
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `design` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal','HSN',NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000',NULL,'{\"tables\":{\"table_label\":null},\"service_staff\":{\"service_staff_label\":null}}',1,1,'classic',NULL,NULL,NULL,'[\"VAT\",null,null,null]','2018-04-03 18:05:32','2018-12-13 00:39:59'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,2,'classic',NULL,NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,4,'classic',NULL,NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(5,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,5,'classic',NULL,NULL,NULL,NULL,'2018-07-13 11:12:11','2018-07-13 11:12:11'),(6,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,6,'classic',NULL,NULL,NULL,NULL,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(7,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,7,'classic',NULL,NULL,NULL,NULL,'2018-11-26 07:53:58','2018-11-26 07:53:58'),(8,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,8,'classic',NULL,NULL,NULL,NULL,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(9,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,9,'classic',NULL,NULL,NULL,NULL,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(10,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,10,'classic',NULL,NULL,NULL,NULL,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(11,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,11,'classic',NULL,NULL,NULL,NULL,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(12,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,12,'classic',NULL,NULL,NULL,NULL,'2018-12-12 06:20:44','2018-12-12 06:20:44');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','AS',1,14,4,1,'2018-01-03 20:45:20','2018-12-13 00:33:30'),(2,2,'Default','blank','AP',1,3,4,1,'2018-04-10 02:42:40','2018-04-10 04:56:12'),(4,4,'Default','blank','',1,8,4,1,'2018-04-10 06:50:43','2018-04-10 07:38:49'),(5,5,'Default','blank','',1,4,4,1,'2018-07-13 05:42:11','2018-07-12 20:46:36'),(6,6,'Default','blank','',1,0,4,1,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(7,7,'Default','blank','',1,0,4,1,'2018-11-26 07:53:58','2018-11-26 07:53:58'),(8,8,'Default','blank','',1,0,4,1,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(9,9,'Default','blank','',1,0,4,1,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(10,10,'Default','blank','',1,0,4,1,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(11,11,'Default','blank','',1,0,4,1,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(12,12,'Default','blank','',1,0,4,1,'2018-12-12 06:20:44','2018-12-12 06:20:44');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=184 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2017_07_05_071953_create_currencies_table',1),(4,'2017_07_05_073658_create_business_table',1),(5,'2017_07_22_075923_add_business_id_users_table',1),(6,'2017_07_23_113209_create_brands_table',1),(7,'2017_07_26_083429_create_permission_tables',1),(8,'2017_07_26_110000_create_tax_rates_table',1),(9,'2017_07_26_122313_create_units_table',1),(10,'2017_07_27_075706_create_contacts_table',1),(11,'2017_08_04_071038_create_categories_table',1),(12,'2017_08_08_115903_create_products_table',1),(13,'2017_08_09_061616_create_variation_templates_table',1),(14,'2017_08_09_061638_create_variation_value_templates_table',1),(15,'2017_08_10_061146_create_product_variations_table',1),(16,'2017_08_10_061216_create_variations_table',1),(17,'2017_08_19_054827_create_transactions_table',1),(18,'2017_08_31_073533_create_purchase_lines_table',1),(19,'2017_10_15_064638_create_transaction_payments_table',1),(20,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(21,'2017_11_20_051930_create_table_group_sub_taxes',1),(22,'2017_11_20_063603_create_transaction_sell_lines',1),(23,'2017_11_21_064540_create_barcodes_table',1),(24,'2017_11_23_181237_create_invoice_schemes_table',1),(25,'2017_12_25_122822_create_business_locations_table',1),(26,'2017_12_25_160253_add_location_id_to_transactions_table',1),(27,'2017_12_25_163227_create_variation_location_details_table',1),(28,'2018_01_04_115627_create_sessions_table',1),(29,'2018_01_05_112817_create_invoice_layouts_table',1),(30,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(31,'2018_01_08_104124_create_expense_categories_table',1),(32,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(33,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(34,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(35,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(36,'2018_01_27_184322_create_printers_table',1),(37,'2018_01_30_181442_create_cash_registers_table',1),(38,'2018_01_31_125836_create_cash_register_transactions_table',1),(39,'2018_02_07_173326_modify_business_table',1),(40,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(41,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(42,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(43,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(44,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(45,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(46,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(47,'2018_02_13_183323_alter_decimal_fields_size',1),(48,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(49,'2018_02_15_161032_add_document_column_to_transactions_table',1),(50,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(51,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(52,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(53,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(54,'2018_02_21_105329_create_system_table',1),(55,'2018_02_23_100549_version_1_2',1),(56,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(57,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(58,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(59,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(60,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(61,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(62,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(63,'2018_03_06_210206_modify_product_barcode_types',1),(64,'2018_03_13_181541_add_expiry_type_to_business_table',1),(65,'2018_03_16_113446_product_expiry_setting_for_business',1),(66,'2018_03_19_113601_add_business_settings_options',1),(67,'2018_03_26_125334_add_pos_settings_to_business_table',1),(68,'2018_03_26_165350_create_customer_groups_table',1),(69,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(70,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(71,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(72,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(73,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(74,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(75,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(76,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(77,'2018_04_17_123122_add_lot_number_to_business',1),(78,'2018_04_17_160845_add_product_racks_table',1),(79,'2018_04_20_182015_create_res_tables_table',1),(80,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(81,'2018_04_24_114149_add_enabled_modules_business_table',1),(82,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(83,'2018_04_27_132653_quotation_related_change',1),(84,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(85,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(86,'2018_05_14_114027_add_rows_positions_for_products',1),(87,'2018_05_14_125223_add_weight_to_products_table',1),(88,'2018_05_14_164754_add_opening_stock_permission',1),(89,'2018_05_15_134729_add_design_to_invoice_layouts',1),(90,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(91,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(92,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(93,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(94,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(95,'2018_05_22_123527_create_reference_counts_table',1),(96,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(97,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(98,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(99,'2018_05_25_180603_create_modifiers_related_table',1),(100,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(101,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(102,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(103,'2018_06_05_111905_modify_products_table_for_modifiers',1),(104,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(105,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(106,'2018_06_07_182258_add_image_field_to_products_table',1),(107,'2018_06_13_133705_create_bookings_table',1),(108,'2018_06_15_173636_add_email_column_to_contacts_table',1),(109,'2018_06_27_182835_add_superadmin_related_fields_business',1),(110,'2018_06_27_185405_create_packages_table',1),(111,'2018_06_28_182803_create_subscriptions_table',1),(112,'2018_07_10_101913_add_custom_fields_to_products_table',1),(113,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(114,'2018_07_17_120612_change_all_quantity_field_type_to_decimal',1),(115,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(116,'2018_07_17_182021_add_rows_to_system_table',1),(117,'2018_07_19_131721_add_options_to_packages_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_08_17_155534_add_min_termination_alert_days',1),(128,'2018_08_28_105945_add_business_based_username_settings_to_system_table',1),(129,'2018_08_30_105906_add_superadmin_communicator_logs_table',1),(130,'2018_09_04_155900_create_accounts_table',1),(131,'2018_09_04_160134_add_accounts_module_version',1),(132,'2018_09_06_114438_create_selling_price_groups_table',1),(133,'2018_09_06_154057_create_variation_group_prices_table',1),(134,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(135,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(136,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(137,'2018_09_10_152703_create_account_transactions_table',1),(138,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(139,'2018_09_19_123914_create_notification_templates_table',1),(140,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(141,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(142,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(143,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(144,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(145,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(146,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(147,'2018_10_03_185947_add_default_notification_templates_to_database',1),(148,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(149,'2018_10_10_110400_add_module_version_to_system_table',1),(150,'2018_10_10_122845_add_woocommerce_api_settings_to_business_table',1),(151,'2018_10_10_162041_add_woocommerce_category_id_to_categories_table',1),(152,'2018_10_11_173839_create_woocommerce_sync_logs_table',1),(153,'2018_10_16_123522_add_woocommerce_tax_rate_id_column_to_tax_rates_table',1),(154,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(155,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(156,'2018_10_22_134428_modify_variable_product_data',1),(157,'2018_10_23_111555_add_woocommerce_attr_id_column_to_variation_templates_table',1),(158,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(159,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(160,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(161,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(162,'2018_10_31_175627_add_user_contact_access',1),(163,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(164,'2018_11_02_130636_add_custom_permissions_to_packages_table',1),(165,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(166,'2018_11_05_161848_add_more_fields_to_packages_table',1),(167,'2018_11_08_105621_add_role_permissions',1),(168,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',2),(169,'2018_07_24_152720_create_payment_accounts_table',3),(170,'2018_10_01_151252_create_documents_table',3),(171,'2018_10_02_151803_create_document_shares_table',3),(172,'2018_10_09_134558_create_reminders_table',3),(173,'2018_11_16_170756_create_to_dos_table',3),(174,'2018_11_29_115918_add_primary_key_in_system_table',4),(175,'2018_12_03_163945_add_woocommerce_permissions',5),(176,'2018_12_03_185546_add_product_description_column_to_products_table',5),(177,'2018_12_06_114937_modify_system_table_and_users_table',6),(178,'2018_12_10_124621_modify_system_table_values_null_default',7),(179,'2018_07_18_104802_add_column_to_product_table',8),(180,'2018_08_04_115904_add_delivery_status_to_transactions_table',8),(181,'2018_09_21_114955_add_enum_attribute_in_transactions_table',8),(182,'2018_09_21_131048_add_expense_transaction_id_in_transactions_table',8),(183,'2018_12_11_185056_add_pl_payment_status_column_to_purchase_lines_table',8);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,1,'App\\User'),(2,2,'App\\User'),(1,3,'App\\User'),(3,4,'App\\User'),(7,6,'App\\User'),(9,7,'App\\User'),(11,8,'App\\User'),(1,9,'App\\User'),(1,10,'App\\User'),(1,11,'App\\User'),(12,12,'App\\User'),(14,13,'App\\User'),(16,14,'App\\User'),(18,15,'App\\User'),(20,16,'App\\User'),(25,17,'App\\User'),(27,18,'App\\User');
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci,
  `sms_body` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,NULL,NULL),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,NULL,NULL),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,NULL,NULL),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,NULL,NULL),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,NULL,NULL),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,NULL,NULL),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,NULL,NULL),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,NULL,NULL),(9,2,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,NULL,NULL),(10,2,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,NULL,NULL),(11,2,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,NULL,NULL),(12,2,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,NULL,NULL),(13,2,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,NULL,NULL),(14,2,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,NULL,NULL),(15,2,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,NULL,NULL),(16,2,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,NULL,NULL),(17,3,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,NULL,NULL),(18,3,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,NULL,NULL),(19,3,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,NULL,NULL),(20,3,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,NULL,NULL),(21,3,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,NULL,NULL),(22,3,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,NULL,NULL),(23,3,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,NULL,NULL),(24,3,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,NULL,NULL),(25,4,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,NULL,NULL),(26,4,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,NULL,NULL),(27,4,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,NULL,NULL),(28,4,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,NULL,NULL),(29,4,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,NULL,NULL),(30,4,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,NULL,NULL),(31,4,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,NULL,NULL),(32,4,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,NULL,NULL),(33,5,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,NULL,NULL),(34,5,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,NULL,NULL),(35,5,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,NULL,NULL),(36,5,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,NULL,NULL),(37,5,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,NULL,NULL),(38,5,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,NULL,NULL),(39,5,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,NULL,NULL),(40,5,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,NULL,NULL),(41,6,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(42,6,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(43,6,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(44,6,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(45,6,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(46,6,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(47,6,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(48,6,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(49,7,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2018-11-26 07:53:58','2018-11-26 07:53:58'),(50,7,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(51,7,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(52,7,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(53,7,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(54,7,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(55,7,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(56,7,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(57,8,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(58,8,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(59,8,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(60,8,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(61,8,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(62,8,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(63,8,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(64,8,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(65,9,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(66,9,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(67,9,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(68,9,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(69,9,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(70,9,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(71,9,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(72,9,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(73,10,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(74,10,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(75,10,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(76,10,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(77,10,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(78,10,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(79,10,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(80,10,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(81,11,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(82,11,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(83,11,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(84,11,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(85,11,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(86,11,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(87,11,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(88,11,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(89,12,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2018-12-12 06:20:45','2018-12-12 06:20:45'),(90,12,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2018-12-12 06:20:45','2018-12-12 06:20:45'),(91,12,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2018-12-12 06:20:45','2018-12-12 06:20:45'),(92,12,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2018-12-12 06:20:45','2018-12-12 06:20:45'),(93,12,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2018-12-12 06:20:45','2018-12-12 06:20:45'),(94,12,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2018-12-12 06:20:45','2018-12-12 06:20:45'),(95,12,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2018-12-12 06:20:45','2018-12-12 06:20:45'),(96,12,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2018-12-12 06:20:45','2018-12-12 06:20:45');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') COLLATE utf8mb4_unicode_ci NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(20,4) NOT NULL,
  `custom_permissions` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `is_one_time` tinyint(1) NOT NULL DEFAULT '0',
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT '0',
  `custom_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_link_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'Starter - Free','Give it a test drive...',1,2,30,0,0,0,0,30,'months',1,10,0.0000,'',1,0,1,0,0,0,NULL,NULL,NULL,'2018-11-12 07:53:27','2018-08-01 14:40:49'),(2,'Regular','For Small Shops',2,4,1000,0,0,0,0,800,'months',1,10,199.9900,'',1,1,1,0,0,0,NULL,NULL,NULL,'2018-11-12 07:53:27','2018-08-01 14:42:30'),(3,'Unlimited','For Large Business',0,0,0,0,0,0,0,0,'months',1,10,599.9900,'',1,1,1,0,0,0,NULL,NULL,NULL,'2018-11-12 07:53:27','2018-08-01 14:43:50'),(4,'Business','For Small & Growing Shops...',10,10,15000,0,0,0,0,1000,'months',1,10,259.9900,'',1,5,0,0,0,0,NULL,NULL,NULL,'2018-11-12 07:53:27','2018-08-01 14:46:14');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_accounts` WRITE;
/*!40000 ALTER TABLE `payment_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2018-11-12 07:50:22',NULL),(2,'direct_sell.access','web','2018-11-12 07:50:22',NULL),(3,'product.opening_stock','web','2018-11-12 07:51:23','2018-11-12 07:51:23'),(4,'crud_all_bookings','web','2018-11-12 07:51:47','2018-11-12 07:51:47'),(5,'crud_own_bookings','web','2018-11-12 07:51:47','2018-11-12 07:51:47'),(6,'access_default_selling_price','web','2018-11-12 07:52:40','2018-11-12 07:52:40'),(7,'purchase.payments','web','2018-11-12 07:53:02','2018-11-12 07:53:02'),(8,'sell.payments','web','2018-11-12 07:53:02','2018-11-12 07:53:02'),(9,'edit_product_price_from_sale_screen','web','2018-11-12 07:53:15','2018-11-12 07:53:15'),(10,'edit_product_discount_from_sale_screen','web','2018-11-12 07:53:16','2018-11-12 07:53:16'),(11,'roles.view','web','2018-11-12 07:53:24','2018-11-12 07:53:24'),(12,'roles.create','web','2018-11-12 07:53:25','2018-11-12 07:53:25'),(13,'roles.update','web','2018-11-12 07:53:25','2018-11-12 07:53:25'),(14,'roles.delete','web','2018-11-12 07:53:25','2018-11-12 07:53:25'),(15,'user.view','web','2018-11-12 07:53:26',NULL),(16,'user.create','web','2018-11-12 07:53:26',NULL),(17,'user.update','web','2018-11-12 07:53:26',NULL),(18,'user.delete','web','2018-11-12 07:53:26',NULL),(19,'supplier.view','web','2018-11-12 07:53:26',NULL),(20,'supplier.create','web','2018-11-12 07:53:26',NULL),(21,'supplier.update','web','2018-11-12 07:53:26',NULL),(22,'supplier.delete','web','2018-11-12 07:53:26',NULL),(23,'customer.view','web','2018-11-12 07:53:26',NULL),(24,'customer.create','web','2018-11-12 07:53:26',NULL),(25,'customer.update','web','2018-11-12 07:53:26',NULL),(26,'customer.delete','web','2018-11-12 07:53:26',NULL),(27,'product.view','web','2018-11-12 07:53:26',NULL),(28,'product.create','web','2018-11-12 07:53:26',NULL),(29,'product.update','web','2018-11-12 07:53:26',NULL),(30,'product.delete','web','2018-11-12 07:53:26',NULL),(31,'purchase.view','web','2018-11-12 07:53:26',NULL),(32,'purchase.create','web','2018-11-12 07:53:26',NULL),(33,'purchase.update','web','2018-11-12 07:53:26',NULL),(34,'purchase.delete','web','2018-11-12 07:53:26',NULL),(35,'sell.view','web','2018-11-12 07:53:26',NULL),(36,'sell.create','web','2018-11-12 07:53:26',NULL),(37,'sell.update','web','2018-11-12 07:53:26',NULL),(38,'sell.delete','web','2018-11-12 07:53:26',NULL),(39,'purchase_n_sell_report.view','web','2018-11-12 07:53:26',NULL),(40,'contacts_report.view','web','2018-11-12 07:53:26',NULL),(41,'stock_report.view','web','2018-11-12 07:53:26',NULL),(42,'tax_report.view','web','2018-11-12 07:53:26',NULL),(43,'trending_product_report.view','web','2018-11-12 07:53:26',NULL),(44,'register_report.view','web','2018-11-12 07:53:26',NULL),(45,'sales_representative.view','web','2018-11-12 07:53:26',NULL),(46,'expense_report.view','web','2018-11-12 07:53:26',NULL),(47,'business_settings.access','web','2018-11-12 07:53:26',NULL),(48,'barcode_settings.access','web','2018-11-12 07:53:26',NULL),(49,'invoice_settings.access','web','2018-11-12 07:53:26',NULL),(50,'brand.view','web','2018-11-12 07:53:26',NULL),(51,'brand.create','web','2018-11-12 07:53:26',NULL),(52,'brand.update','web','2018-11-12 07:53:26',NULL),(53,'brand.delete','web','2018-11-12 07:53:26',NULL),(54,'tax_rate.view','web','2018-11-12 07:53:26',NULL),(55,'tax_rate.create','web','2018-11-12 07:53:26',NULL),(56,'tax_rate.update','web','2018-11-12 07:53:26',NULL),(57,'tax_rate.delete','web','2018-11-12 07:53:26',NULL),(58,'unit.view','web','2018-11-12 07:53:26',NULL),(59,'unit.create','web','2018-11-12 07:53:26',NULL),(60,'unit.update','web','2018-11-12 07:53:26',NULL),(61,'unit.delete','web','2018-11-12 07:53:26',NULL),(62,'category.view','web','2018-11-12 07:53:26',NULL),(63,'category.create','web','2018-11-12 07:53:26',NULL),(64,'category.update','web','2018-11-12 07:53:26',NULL),(65,'category.delete','web','2018-11-12 07:53:26',NULL),(66,'expense.access','web','2018-11-12 07:53:26',NULL),(67,'access_all_locations','web','2018-11-12 07:53:26',NULL),(68,'dashboard.data','web','2018-11-12 07:53:26',NULL),(69,'location.1','web','2018-11-12 07:53:37',NULL),(70,'location.2','web','2018-11-12 07:53:38',NULL),(71,'location.3','web','2018-11-12 07:53:39',NULL),(72,'location.4','web','2018-11-12 07:53:39',NULL),(73,'location.5','web','2018-11-12 07:53:40',NULL),(74,'location.6','web','2018-11-23 10:35:57','2018-11-23 10:35:57'),(75,'location.7','web','2018-11-26 07:53:59','2018-11-26 07:53:59'),(76,'location.8','web','2018-11-28 06:31:02','2018-11-28 06:31:02'),(77,'location.9','web','2018-11-30 07:55:35','2018-11-30 07:55:35'),(78,'location.10','web','2018-11-30 13:37:31','2018-11-30 13:37:31'),(79,'woocommerce.syc_categories','web','2018-12-04 07:34:16','2018-12-04 07:34:16'),(80,'woocommerce.sync_products','web','2018-12-04 07:34:16','2018-12-04 07:34:16'),(81,'woocommerce.sync_orders','web','2018-12-04 07:34:16','2018-12-04 07:34:16'),(82,'woocommerce.map_tax_rates','web','2018-12-04 07:34:17','2018-12-04 07:34:17'),(83,'woocommerce.access_woocommerce_api_settings','web','2018-12-04 07:34:17','2018-12-04 07:34:17'),(84,'location.11','web','2018-12-11 08:10:02','2018-12-11 08:10:02'),(85,'location.12','web','2018-12-12 06:20:45','2018-12-12 06:20:45');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=884 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2018-01-03 15:59:08','2018-01-03 15:59:08'),(2,5,'Waist Size',2,0,'2018-01-03 16:00:35','2018-11-12 07:53:40'),(3,6,'Size',3,0,'2018-01-03 17:21:52','2018-11-12 07:53:41'),(4,6,'Size',4,0,'2018-01-03 17:24:34','2018-11-12 07:53:42'),(8,6,'Size',8,0,'2018-01-03 17:40:10','2018-11-12 07:53:43'),(9,6,'Size',9,0,'2018-01-03 17:41:57','2018-11-12 07:53:43'),(10,6,'Size',10,0,'2018-01-03 17:43:02','2018-11-12 07:53:43'),(11,NULL,'DUMMY',11,1,'2018-01-03 17:44:35','2018-01-03 17:44:35'),(12,NULL,'DUMMY',12,1,'2018-01-03 17:45:50','2018-01-03 17:45:50'),(13,6,'Size',13,0,'2018-01-03 17:47:59','2018-11-12 07:53:44'),(14,4,'Color',14,0,'2018-01-06 00:12:19','2018-11-12 07:53:44'),(15,7,'Internal Memory',14,0,'2018-01-06 00:14:14','2018-11-12 07:53:44'),(16,4,'Color',15,0,'2018-01-06 00:19:51','2018-11-12 07:53:45'),(17,7,'Internal Memory',15,0,'2018-01-06 00:19:51','2018-11-12 07:53:45'),(18,4,'Color',16,0,'2018-01-06 00:24:48','2018-11-12 07:53:45'),(19,4,'Color',17,0,'2018-01-06 00:35:01','2018-11-12 07:53:46'),(20,8,'Storage',18,0,'2018-01-06 00:37:30','2018-11-12 07:53:46'),(21,NULL,'DUMMY',19,1,'2018-01-06 00:40:28','2018-01-06 00:40:28'),(22,4,'Color',20,0,'2018-01-06 00:43:00','2018-11-12 07:53:46'),(23,NULL,'DUMMY',21,1,'2018-01-06 00:46:35','2018-01-06 00:46:35'),(24,NULL,'DUMMY',22,1,'2018-01-06 00:55:09','2018-01-06 00:55:09'),(25,NULL,'DUMMY',23,1,'2018-01-06 00:56:27','2018-01-06 00:56:27'),(26,NULL,'DUMMY',24,1,'2018-01-06 01:01:22','2018-01-06 01:01:22'),(27,NULL,'DUMMY',25,1,'2018-01-06 01:02:23','2018-01-06 01:02:23'),(28,NULL,'DUMMY',26,1,'2018-01-06 01:05:51','2018-01-06 01:05:51'),(29,NULL,'DUMMY',27,1,'2018-01-06 01:13:16','2018-01-06 01:13:16'),(30,NULL,'DUMMY',28,1,'2018-01-06 01:15:47','2018-01-06 01:15:47'),(31,NULL,'DUMMY',29,1,'2018-01-06 01:16:53','2018-01-06 01:16:53'),(32,NULL,'DUMMY',30,1,'2018-01-06 01:18:59','2018-01-06 01:18:59'),(33,NULL,'DUMMY',31,1,'2018-04-10 04:36:29','2018-04-10 04:36:29'),(34,NULL,'DUMMY',32,1,'2018-04-10 04:37:52','2018-04-10 04:37:52'),(35,NULL,'DUMMY',33,1,'2018-04-10 04:39:45','2018-04-10 04:39:45'),(36,NULL,'DUMMY',34,1,'2018-04-10 04:40:59','2018-04-10 04:40:59'),(37,NULL,'DUMMY',35,1,'2018-04-10 04:42:53','2018-04-10 04:42:53'),(38,NULL,'DUMMY',36,1,'2018-04-10 04:44:18','2018-04-10 04:44:18'),(39,NULL,'DUMMY',37,1,'2018-04-10 05:01:29','2018-04-10 05:01:29'),(40,NULL,'DUMMY',38,1,'2018-04-10 05:02:35','2018-04-10 05:02:35'),(41,NULL,'DUMMY',39,1,'2018-04-10 05:03:26','2018-04-10 05:03:26'),(42,NULL,'DUMMY',40,1,'2018-04-10 05:04:32','2018-04-10 05:04:32'),(53,NULL,'DUMMY',51,1,'2018-04-10 07:04:57','2018-04-10 07:04:57'),(54,NULL,'DUMMY',52,1,'2018-04-10 07:05:55','2018-04-10 07:05:55'),(55,NULL,'DUMMY',53,1,'2018-04-10 07:09:15','2018-04-10 07:09:15'),(56,NULL,'DUMMY',54,1,'2018-04-10 07:24:16','2018-04-10 07:24:16'),(57,NULL,'DUMMY',55,1,'2018-04-10 07:26:18','2018-04-10 07:26:18'),(58,NULL,'DUMMY',56,1,'2018-04-10 07:31:59','2018-04-10 07:31:59'),(59,NULL,'DUMMY',57,1,'2018-04-10 07:33:01','2018-04-10 07:33:01'),(60,NULL,'DUMMY',58,1,'2018-04-10 07:33:37','2018-04-10 07:33:37'),(61,NULL,'DUMMY',59,1,'2018-04-10 07:36:45','2018-04-10 07:36:45'),(62,NULL,'DUMMY',60,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(63,NULL,'DUMMY',61,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(64,NULL,'DUMMY',62,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(65,NULL,'DUMMY',63,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(66,NULL,'DUMMY',64,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(67,NULL,'DUMMY',65,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(68,NULL,'DUMMY',66,1,'2018-07-12 19:30:31','2018-07-12 19:30:31'),(69,NULL,'DUMMY',67,1,'2018-07-12 19:34:47','2018-07-12 19:34:47'),(70,NULL,'DUMMY',68,1,'2018-07-12 19:38:55','2018-07-12 19:38:55'),(71,NULL,'DUMMY',69,1,'2018-07-12 19:45:51','2018-07-12 19:45:51'),(72,NULL,'DUMMY',70,1,'2018-07-12 19:57:37','2018-07-12 19:57:37'),(73,NULL,'DUMMY',71,1,'2018-07-12 20:00:41','2018-07-12 20:00:41'),(74,NULL,'DUMMY',72,1,'2018-07-12 20:05:03','2018-07-12 20:05:03'),(75,NULL,'DUMMY',73,1,'2018-07-12 20:07:29','2018-07-12 20:07:29'),(76,NULL,'DUMMY',74,1,'2018-07-12 20:10:44','2018-07-12 20:10:44'),(77,NULL,'DUMMY',75,1,'2018-07-12 20:13:09','2018-07-12 20:13:09'),(78,NULL,'DUMMY',76,1,'2018-07-12 20:18:33','2018-07-12 20:18:33'),(79,NULL,'DUMMY',77,1,'2018-07-12 20:24:22','2018-07-12 20:24:22'),(80,NULL,'DUMMY',78,0,'2018-07-16 02:28:04','2018-07-16 02:28:04'),(81,NULL,'DUMMY',79,0,'2018-07-16 02:35:37','2018-07-16 02:35:37'),(82,NULL,'DUMMY',80,1,'2018-11-12 03:58:24','2018-11-12 03:58:24'),(83,NULL,'DUMMY',81,1,'2018-11-12 03:58:57','2018-11-12 03:58:57'),(664,NULL,'DUMMY',662,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(665,NULL,'DUMMY',663,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(666,NULL,'DUMMY',664,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(667,NULL,'DUMMY',665,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(668,NULL,'DUMMY',666,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(669,NULL,'DUMMY',667,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(670,NULL,'DUMMY',668,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(671,NULL,'DUMMY',669,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(672,NULL,'DUMMY',670,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(673,NULL,'DUMMY',671,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(674,NULL,'DUMMY',672,1,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(675,NULL,'DUMMY',673,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(676,NULL,'DUMMY',674,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(677,NULL,'DUMMY',675,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(678,NULL,'DUMMY',676,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(679,NULL,'DUMMY',677,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(680,NULL,'DUMMY',678,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(681,NULL,'DUMMY',679,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(682,NULL,'DUMMY',680,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(683,NULL,'DUMMY',681,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(684,NULL,'DUMMY',682,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(685,NULL,'DUMMY',683,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(686,NULL,'DUMMY',684,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(687,NULL,'DUMMY',685,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(688,NULL,'DUMMY',686,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(689,NULL,'DUMMY',687,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(690,NULL,'DUMMY',688,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(691,NULL,'DUMMY',689,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(692,NULL,'DUMMY',690,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(693,NULL,'DUMMY',691,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(694,NULL,'DUMMY',692,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(695,NULL,'DUMMY',693,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(696,NULL,'DUMMY',694,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(697,NULL,'DUMMY',695,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(698,NULL,'DUMMY',696,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(699,NULL,'DUMMY',697,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(700,NULL,'DUMMY',698,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(701,NULL,'DUMMY',699,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(702,NULL,'DUMMY',700,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(703,NULL,'DUMMY',701,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(704,NULL,'DUMMY',702,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(705,NULL,'DUMMY',703,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(706,NULL,'DUMMY',704,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(707,NULL,'DUMMY',705,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(708,NULL,'DUMMY',706,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(709,NULL,'DUMMY',707,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(710,NULL,'DUMMY',708,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(711,NULL,'DUMMY',709,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(712,NULL,'DUMMY',710,1,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(747,NULL,'DUMMY',745,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(748,NULL,'DUMMY',746,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(749,NULL,'DUMMY',747,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(750,NULL,'DUMMY',748,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(751,NULL,'DUMMY',749,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(752,NULL,'DUMMY',750,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(753,NULL,'DUMMY',751,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(754,NULL,'DUMMY',752,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(755,NULL,'DUMMY',753,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(756,NULL,'DUMMY',754,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(757,NULL,'DUMMY',755,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(758,NULL,'DUMMY',756,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(759,NULL,'DUMMY',757,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(760,NULL,'DUMMY',758,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(761,NULL,'DUMMY',759,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(762,NULL,'DUMMY',760,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(763,NULL,'DUMMY',761,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(764,NULL,'DUMMY',762,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(765,NULL,'DUMMY',763,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(766,NULL,'DUMMY',764,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(767,NULL,'DUMMY',765,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(768,NULL,'DUMMY',766,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(769,NULL,'DUMMY',767,1,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(770,NULL,'DUMMY',768,1,'2018-11-12 04:37:23','2018-11-12 04:37:23'),(781,NULL,'DUMMY',779,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(782,NULL,'DUMMY',780,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(783,NULL,'DUMMY',781,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(784,NULL,'DUMMY',782,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(785,NULL,'DUMMY',783,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(786,NULL,'DUMMY',784,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(787,NULL,'DUMMY',785,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(788,NULL,'DUMMY',786,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(789,NULL,'DUMMY',787,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(790,NULL,'DUMMY',788,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(791,NULL,'DUMMY',789,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(792,NULL,'DUMMY',790,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(793,NULL,'DUMMY',791,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(794,NULL,'DUMMY',792,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(795,NULL,'DUMMY',793,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(796,NULL,'DUMMY',794,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(797,NULL,'DUMMY',795,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(798,NULL,'DUMMY',796,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(799,NULL,'DUMMY',797,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(800,NULL,'DUMMY',798,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(801,NULL,'DUMMY',799,1,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(812,NULL,'DUMMY',810,1,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(813,NULL,'DUMMY',811,1,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(814,NULL,'DUMMY',812,1,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(815,NULL,'DUMMY',813,1,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(816,NULL,'DUMMY',814,1,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(817,NULL,'DUMMY',815,1,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(818,NULL,'DUMMY',816,1,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(819,NULL,'DUMMY',817,1,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(832,NULL,'DUMMY',830,1,'2018-11-12 04:41:09','2018-11-12 04:41:09'),(839,6,'size',837,0,'2018-11-12 04:51:17','2018-11-12 04:51:17'),(844,NULL,'DUMMY',842,1,'2018-11-12 04:55:45','2018-11-12 04:55:45'),(845,36,'Small',843,0,'2018-11-12 04:55:45','2018-11-12 04:55:45'),(846,NULL,'DUMMY',844,1,'2018-11-14 22:11:13','2018-11-14 22:11:13'),(847,NULL,'DUMMY',845,1,'2018-11-14 22:11:56','2018-11-14 22:11:56'),(848,NULL,'DUMMY',846,1,'2018-11-14 22:12:47','2018-11-14 22:12:47'),(849,NULL,'DUMMY',847,1,'2018-11-14 23:12:24','2018-11-14 23:12:24'),(850,NULL,'DUMMY',848,1,'2018-11-14 23:12:24','2018-11-14 23:12:24'),(851,NULL,'DUMMY',849,1,'2018-11-14 23:14:53','2018-11-14 23:14:53'),(852,NULL,'DUMMY',850,1,'2018-11-14 23:14:53','2018-11-14 23:14:53'),(853,NULL,'DUMMY',851,1,'2018-11-14 23:15:41','2018-11-14 23:15:41'),(854,NULL,'DUMMY',852,1,'2018-11-15 00:44:56','2018-11-15 00:44:56'),(855,NULL,'DUMMY',853,1,'2018-11-15 00:44:56','2018-11-15 00:44:56'),(856,NULL,'DUMMY',854,1,'2018-11-15 00:46:28','2018-11-15 00:46:28'),(857,NULL,'DUMMY',855,1,'2018-11-15 00:46:51','2018-11-15 00:46:51'),(858,NULL,'DUMMY',856,1,'2018-11-15 00:47:55','2018-11-15 00:47:55'),(859,NULL,'DUMMY',857,1,'2018-11-15 00:48:12','2018-11-15 00:48:12'),(860,NULL,'DUMMY',858,1,'2018-11-15 00:49:54','2018-11-15 00:49:54'),(861,NULL,'DUMMY',859,1,'2018-11-15 00:50:18','2018-11-15 00:50:18'),(862,NULL,'DUMMY',860,1,'2018-11-15 01:07:01','2018-11-15 01:07:01'),(863,NULL,'DUMMY',861,1,'2018-11-23 10:49:23','2018-11-23 10:49:23'),(864,NULL,'DUMMY',862,1,'2018-11-26 08:09:03','2018-11-26 08:09:03'),(865,NULL,'DUMMY',863,1,'2018-11-27 17:56:15','2018-11-27 17:56:15'),(866,NULL,'DUMMY',864,1,'2018-11-27 17:56:42','2018-11-27 17:56:42'),(867,NULL,'DUMMY',865,1,'2018-11-30 07:56:26','2018-11-30 07:56:26'),(868,NULL,'DUMMY',866,1,'2018-11-30 08:10:23','2018-11-30 08:10:23'),(870,37,'Size',868,0,'2018-11-30 08:13:47','2018-11-30 08:13:47'),(871,NULL,'DUMMY',869,1,'2018-11-30 12:24:14','2018-11-30 12:24:14'),(872,NULL,'DUMMY',870,1,'2018-11-30 12:25:39','2018-11-30 12:25:39'),(873,37,'Size',871,0,'2018-11-30 12:34:06','2018-11-30 12:34:06'),(874,37,'Size',872,0,'2018-11-30 12:36:15','2018-11-30 12:36:15'),(875,37,'Size',873,0,'2018-11-30 12:50:29','2018-11-30 12:50:29'),(876,37,'Size',874,0,'2018-11-30 12:55:36','2018-11-30 12:55:36'),(877,37,'Size',875,0,'2018-11-30 13:01:42','2018-11-30 13:01:42'),(878,37,'Size',876,0,'2018-11-30 13:04:07','2018-11-30 13:04:07'),(879,NULL,'DUMMY',877,1,'2018-12-03 22:07:27','2018-12-03 22:07:27'),(880,NULL,'DUMMY',878,1,'2018-12-05 23:24:06','2018-12-05 23:24:06'),(881,NULL,'DUMMY',879,1,'2018-12-05 23:24:06','2018-12-05 23:24:06'),(882,NULL,'DUMMY',880,1,'2018-12-06 19:30:32','2018-12-06 19:30:32'),(883,NULL,'DUMMY',881,1,'2018-12-06 23:30:54','2018-12-06 23:30:54');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` int(11) NOT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_product_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=882 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'Men\'s Reverse Fleece Crew',1,'single',1,1,1,5,1,'exclusive',1,5,'AS0001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728059_fleece_crew.jpg',NULL,1,NULL,'2018-01-03 15:59:08','2018-06-11 02:10:59'),(2,'Levis Men\'s Slimmy Fit Jeans',1,'variable',1,1,1,4,1,'exclusive',1,10,'AS0002','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727964_levis_jeans.jpg',NULL,1,NULL,'2018-01-03 16:00:35','2018-06-11 02:09:24'),(3,'Men\'s Cozy Hoodie Sweater',1,'variable',1,2,1,5,1,'exclusive',1,10,'AS0003','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728035_cozy_sweater.jpg',NULL,1,NULL,'2018-01-03 17:21:52','2018-06-11 02:10:35'),(4,'Puma Brown Sneaker',1,'variable',1,5,3,8,1,'exclusive',1,5,'AS0004','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728147_puma_brown_sneaker.jpg',NULL,1,NULL,'2018-01-03 17:24:33','2018-06-11 02:12:27'),(8,'Nike Fashion Sneaker',1,'variable',1,4,3,8,1,'exclusive',1,10,'AS0008','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728076_nike_sneaker.jpg',NULL,1,NULL,'2018-01-03 17:40:10','2018-06-11 02:11:16'),(9,'PUMA Men\'s Black Sneaker',1,'variable',1,5,3,8,1,'exclusive',1,10,'AS0009','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728163_puma_brown_sneaker.jpg',NULL,1,NULL,'2018-01-03 17:41:57','2018-06-11 02:12:43'),(10,'NIKE Men\'s Running Shoe',1,'variable',1,4,3,8,1,'exclusive',1,10,'AS0010','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728095_nike_running_shoe.jpg',NULL,1,NULL,'2018-01-03 17:43:02','2018-06-11 02:11:35'),(11,'U.S. Polo Men\'s Leather Belt',1,'single',1,3,3,6,1,'exclusive',1,15,'AS0011','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727768_belt.jpg',NULL,1,NULL,'2018-01-03 17:44:35','2018-06-11 02:06:08'),(12,'Unisex Brown Leather Wallet',1,'single',1,1,3,11,1,'exclusive',1,10,'AS0012','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727750_unisex_brown_wallet.jpg',NULL,1,NULL,'2018-01-03 17:45:50','2018-06-11 02:05:50'),(13,'Men Full sleeve T Shirt',1,'variable',1,2,1,5,1,'exclusive',1,15,'AS0013','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728019_mens_tshirt.jpg',NULL,1,NULL,'2018-01-03 17:47:59','2018-06-11 02:10:19'),(14,'Samsung Galaxy S8',1,'variable',1,7,12,13,1,'exclusive',1,100,'AS0014','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728193_s8.jpg',NULL,1,NULL,'2018-01-06 00:12:19','2018-06-11 02:13:13'),(15,'Apple iPhone 8',1,'variable',1,8,12,13,1,'exclusive',1,100,'AS0015','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727817_iphone8.jpg',NULL,1,NULL,'2018-01-06 00:19:51','2018-06-11 02:06:57'),(16,'Samsung Galaxy J7 Pro',1,'variable',1,7,12,13,NULL,'exclusive',1,100,'AS0016','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728178_j7_pro.jpg',NULL,1,NULL,'2018-01-06 00:24:48','2018-06-11 02:12:58'),(17,'Acer Aspire E 15',1,'variable',1,9,12,14,NULL,'exclusive',1,70,'AS0017','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727793_acerE15.jpg',NULL,1,NULL,'2018-01-06 00:35:01','2018-06-11 02:06:33'),(18,'Apple MacBook Air',1,'variable',1,8,12,14,NULL,'exclusive',1,30,'AS0018','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727849_macbookair.jpg',NULL,1,NULL,'2018-01-06 00:37:30','2018-06-11 02:07:29'),(19,'Cushion Crew Socks',1,'single',1,4,15,16,NULL,'exclusive',1,100,'AS0019','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727903_socks.jpg',NULL,1,NULL,'2018-01-06 00:40:28','2018-06-11 02:08:23'),(20,'Sports Tights Pants',1,'variable',1,6,15,16,1,'exclusive',1,60,'AS0020','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728250_sports_pant.jpg',NULL,1,NULL,'2018-01-06 00:43:00','2018-06-11 02:14:10'),(21,'Pair Of Dumbbells',1,'single',1,10,15,17,NULL,'exclusive',1,45,'AS0021','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728133_pair_of_dumbell.jpg',NULL,1,NULL,'2018-01-06 00:46:35','2018-06-11 02:12:13'),(22,'Diary of a Wimpy Kid',1,'single',1,NULL,18,20,1,'exclusive',1,20,'AS0022','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727917_diary_of_whimp_kid.jpeg',NULL,1,NULL,'2018-01-06 00:55:09','2018-06-11 02:08:37'),(23,'Sneezy the Snowman',1,'single',1,NULL,18,20,NULL,'exclusive',1,20,'AS0023','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728231_sneezy.jpg',NULL,1,NULL,'2018-01-06 00:56:27','2018-06-11 02:13:51'),(24,'Etched in Sand Autobiography',1,'single',1,NULL,18,19,1,'exclusive',1,30,'AS0024','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727933_etched_in_stone.jpg',NULL,1,NULL,'2018-01-06 01:01:22','2018-06-11 02:08:53'),(25,'Five Presidents',1,'single',1,NULL,18,19,NULL,'exclusive',1,30,'AS0025','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727949_five_pesident.jpg',NULL,1,NULL,'2018-01-06 01:02:22','2018-06-11 02:09:09'),(26,'Oreo Cookies',1,'single',2,11,21,NULL,NULL,'exclusive',1,500,'AS0026','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728111_oreo.jpg',NULL,1,NULL,'2018-01-06 01:05:51','2018-06-11 02:11:51'),(27,'Butter Cookies',1,'single',2,12,21,NULL,1,'exclusive',1,100,'AS0027','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727881_butter_cookies.jpg',NULL,1,NULL,'2018-01-06 01:13:16','2018-06-11 02:08:01'),(28,'Barilla Pasta',1,'single',2,13,21,NULL,1,'exclusive',1,50,'AS0028','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727865_barilla_pasta.jpeg',NULL,1,NULL,'2018-01-06 01:15:47','2018-06-11 02:07:45'),(29,'Thin Spaghetti',1,'single',2,13,21,NULL,NULL,'exclusive',1,100,'AS0029','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728274_thin_spegatti.jpg',NULL,1,NULL,'2018-01-06 01:16:53','2018-06-11 02:14:34'),(30,'Lipton Black Tea Bags',1,'single',2,14,21,NULL,1,'exclusive',1,50,'AS0030','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727999_lipton_tea.jpg',NULL,1,NULL,'2018-01-06 01:18:59','2018-06-11 02:09:59'),(31,'Dolocare 1g paracetol',2,'single',4,16,27,NULL,NULL,'exclusive',1,50,'AP0031','C128',24.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 04:36:29','2018-04-10 04:36:29'),(32,'Lexin 500mg capsule',2,'single',4,16,22,NULL,NULL,'exclusive',1,30,'AP0032','C128',24.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 04:37:52','2018-04-10 04:37:52'),(33,'Oflen-75',2,'single',4,15,22,NULL,NULL,'exclusive',1,30,'AP0033','C128',36.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 04:39:45','2018-04-10 04:39:45'),(34,'Cistiben Forte',2,'single',4,16,22,NULL,NULL,'exclusive',1,25,'AP0034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 04:40:59','2018-04-10 04:40:59'),(35,'Disflatyl drop 30ml',2,'single',4,17,25,NULL,NULL,'exclusive',1,20,'AP0035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 04:42:53','2018-04-10 04:42:53'),(36,'Mycoheal 40',2,'single',4,17,26,NULL,NULL,'exclusive',1,30,'AP0036','C128',6.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 04:44:18','2018-04-10 04:44:18'),(37,'Laboxyl',2,'single',4,16,24,NULL,NULL,'exclusive',1,20,'AP0037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 05:01:29','2018-04-10 05:01:29'),(38,'Fertilex plus men',2,'single',4,15,22,NULL,NULL,'exclusive',1,30,'AP0038','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 05:02:35','2018-04-10 05:02:35'),(39,'vitamin E AIWA',2,'single',4,15,22,NULL,NULL,'exclusive',1,20,'AP0039','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 05:03:26','2018-04-10 05:03:26'),(40,'Glycerol 4g',2,'single',4,16,22,NULL,NULL,'exclusive',1,20,'AP0040','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,'2018-04-10 05:04:32','2018-04-10 05:04:49'),(51,'Oil and filter change',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0051','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:04:57','2018-04-10 07:04:57'),(52,'Removal of wheels and brakes checked',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0052','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:05:55','2018-04-10 07:05:55'),(53,'Full body wash',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0053','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:09:15','2018-04-10 07:09:15'),(54,'Hair Cut',4,'single',6,NULL,35,NULL,NULL,'exclusive',0,0,'AS0054','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:24:16','2018-04-10 07:24:16'),(55,'Wash And Blow Dry',4,'single',6,NULL,35,NULL,NULL,'exclusive',0,0,'AS0055','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:26:18','2018-04-10 07:26:18'),(56,'Thai massage',4,'single',6,NULL,38,NULL,NULL,'exclusive',0,0,'AS0056','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:31:59','2018-04-10 07:31:59'),(57,'Toilet Repair',4,'single',6,NULL,36,NULL,NULL,'exclusive',0,0,'AS0057','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:33:01','2018-04-10 07:33:01'),(58,'Sewer Repair',4,'single',6,NULL,36,NULL,NULL,'exclusive',0,0,'AS0058','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:33:37','2018-04-10 07:33:37'),(59,'Refrigerator Repair',4,'single',6,NULL,NULL,NULL,NULL,'exclusive',0,0,'AS0059','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:36:45','2018-04-10 07:36:45'),(60,'AC Repair',4,'single',6,NULL,NULL,NULL,NULL,'exclusive',0,0,'AS0060','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(61,'Red Wine',1,'single',1,NULL,21,NULL,NULL,'exclusive',1,10,'AS0061','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528779460_wine.jpg',NULL,1,NULL,'2018-06-11 16:27:41','2018-06-11 16:27:41'),(62,'Pinot Noir Red Wine',1,'single',1,NULL,NULL,NULL,NULL,'exclusive',1,10,'AS0062','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528779737_wine2.jpg',NULL,1,NULL,'2018-06-11 16:32:17','2018-06-11 16:32:17'),(63,'Banana',1,'single',1,NULL,NULL,NULL,NULL,'exclusive',1,100,'AS0063','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528780092_banana.jpg',NULL,1,NULL,'2018-06-11 16:38:12','2018-06-11 16:38:12'),(64,'Apple - Fuji',1,'single',1,NULL,21,NULL,NULL,'exclusive',1,50,'AS0064','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528780234_apples.jpg',NULL,1,NULL,'2018-06-11 16:40:34','2018-06-11 16:40:34'),(65,'Organic Egg',1,'single',1,NULL,21,NULL,NULL,'exclusive',1,10,'AS0065','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528780470_eggs.jpg',NULL,1,NULL,'2018-06-11 16:44:00','2018-06-11 16:44:30'),(66,'Honey Roast Chicken',5,'single',7,NULL,39,NULL,NULL,'exclusive',0,0,'AR0066','C128',NULL,NULL,0,'300 gm',NULL,NULL,NULL,NULL,NULL,'1531481431_honey-roast-chicken.jpg',NULL,7,NULL,'2018-07-13 01:00:31','2018-07-13 01:00:31'),(67,'Mushroom and Herb Filled Tomatoes',5,'single',7,NULL,39,NULL,NULL,'exclusive',0,0,'AR0067','C128',NULL,NULL,0,'150 gm',NULL,NULL,NULL,NULL,NULL,'1531481687_tomtoes-with-mushroom_med.jpg',NULL,7,NULL,'2018-07-13 01:04:47','2018-07-13 01:04:47'),(68,'Pasta Carbonara',5,'single',7,NULL,40,NULL,NULL,'exclusive',0,0,'AR0068','C128',NULL,NULL,0,'180 gm',NULL,NULL,NULL,NULL,NULL,'1531481935_pasta.jpg',NULL,7,NULL,'2018-07-13 01:08:55','2018-07-13 01:08:55'),(69,'Chicken Doner Pita with Hummus',5,'single',7,NULL,40,NULL,NULL,'exclusive',0,0,'AR0069','C128',NULL,NULL,0,'180 gm',NULL,NULL,NULL,NULL,NULL,'1531482350_pita.jpg',NULL,7,NULL,'2018-07-13 01:15:50','2018-07-13 01:15:51'),(70,'Falafal Doner Salad',5,'single',7,NULL,41,NULL,NULL,'exclusive',0,0,'AR0070','C128',NULL,NULL,0,'200 gm',NULL,NULL,NULL,NULL,NULL,'1531483057_salad-doner.jpg',NULL,7,NULL,'2018-07-13 01:27:37','2018-07-13 01:27:37'),(71,'Lamb Doner Salad',5,'single',7,NULL,41,NULL,NULL,'exclusive',0,0,'AR0071','C128',NULL,NULL,0,'220 gm',NULL,NULL,NULL,NULL,NULL,'1531483241_lamb-salad.jpg',NULL,7,NULL,'2018-07-13 01:30:41','2018-07-13 01:30:41'),(72,'Chicago-Style Pan Pizza',5,'single',7,NULL,42,NULL,NULL,'exclusive',0,0,'AR0072','C128',NULL,NULL,0,'190 gm',NULL,NULL,NULL,NULL,NULL,'1531483502_pizza1.jpg',NULL,7,NULL,'2018-07-13 01:35:02','2018-07-13 01:35:03'),(73,'Pizza Margherita',5,'single',7,NULL,42,NULL,NULL,'exclusive',0,0,'AR0073','C128',NULL,NULL,0,'200 gm',NULL,NULL,NULL,NULL,NULL,'1531483649_margherita-pizza.jpg',NULL,7,NULL,'2018-07-13 01:37:29','2018-07-13 01:37:29'),(74,'Blueberry-Ginger Mojito',5,'single',7,NULL,44,NULL,NULL,'exclusive',0,0,'AR0074','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1531483843_mojito.jpg',NULL,7,NULL,'2018-07-13 01:40:43','2018-07-13 01:40:44'),(75,'Chocolate Brownie',5,'single',7,NULL,43,NULL,NULL,'exclusive',0,0,'AR0075','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1531483989_Chocolate-Brownies.jpg',NULL,7,NULL,'2018-07-13 01:43:09','2018-07-13 01:43:09'),(76,'Pepsi Soft Drink',5,'single',7,NULL,44,NULL,NULL,'exclusive',1,50,'AR0076','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1531484313_pepsi.jpg',NULL,7,NULL,'2018-07-13 01:48:33','2018-07-13 01:48:33'),(77,'Brown Bread',5,'single',8,NULL,45,NULL,NULL,'exclusive',1,50,'AR0077','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1531484661_brown-bread.jpg',NULL,7,NULL,'2018-07-13 01:54:21','2018-07-13 01:58:56'),(78,'Toppings',5,'modifier',NULL,NULL,NULL,NULL,NULL,'inclusive',0,0,'AR0078','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,NULL,'2018-07-16 02:28:04','2018-07-16 02:28:04'),(79,'Extra',5,'modifier',NULL,NULL,NULL,NULL,NULL,'inclusive',0,0,'AR0079','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,NULL,'2018-07-16 02:35:37','2018-07-16 02:35:37'),(80,'n1',1,'single',1,24,NULL,NULL,NULL,'inclusive',1,0,'AS0080','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 03:58:23','2018-11-12 03:58:23'),(81,'n1',1,'single',1,24,NULL,NULL,NULL,'inclusive',1,0,'AS0081','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 03:58:57','2018-11-12 03:58:57'),(662,'BEEF ULATHIYATHU',1,'single',1,NULL,240,NULL,NULL,'exclusive',0,0,'AS0662','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(663,'BEEF COCONUT FRY',1,'single',1,NULL,240,NULL,NULL,'exclusive',0,0,'AS0663','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(664,'BEEF DRY FRY',1,'single',1,NULL,240,NULL,NULL,'exclusive',0,0,'AS0664','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(665,'MUTTON MASALA',1,'single',1,NULL,241,NULL,NULL,'exclusive',0,0,'AS0665','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(666,'MUTTON ROAST',1,'single',1,NULL,241,NULL,NULL,'exclusive',0,0,'AS0666','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(667,'MUTTON LIVER',1,'single',1,NULL,241,NULL,NULL,'exclusive',0,0,'AS0667','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(668,'MUTTON KURUMA',1,'single',1,NULL,241,NULL,NULL,'exclusive',0,0,'AS0668','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(669,'MUTTON PEPPER ROAST',1,'single',1,NULL,241,NULL,NULL,'exclusive',0,0,'AS0669','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(670,'MUTTON PARTS',1,'single',1,NULL,241,NULL,NULL,'exclusive',0,0,'AS0670','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(671,'DAL THADKA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0671','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(672,'VEG KOFTHA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0672','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:24','2018-11-12 04:36:24'),(673,'VEG JAIPURI',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0673','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(674,'MIX VEG CURRY/ KORMA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0674','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(675,'ALOO GOBI',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0675','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(676,'ALOO PALAK',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0676','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(677,'ALOO MUTTER',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0677','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(678,'ALOO SIMLA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0678','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(679,'ALOO JEERA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0679','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(680,'BINDI FRY/MASALA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0680','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(681,'PANEER KURUMA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0681','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(682,'PANEER KADAI',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0682','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(683,'PANEER PALAK',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0683','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(684,'PANEER BUTTER MASALA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0684','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(685,'PANEER BURJI',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0685','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(686,'MASHROOM MASALA',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0686','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(687,'VEGETABLE STEW',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0687','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(688,'VEGETABLE MIX',1,'single',1,NULL,242,NULL,NULL,'exclusive',0,0,'AS0688','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(689,'CHICKEN MURG MASALA FULL SET',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0689','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(690,'CHICKEN KOLAPUREY',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0690','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(691,'CHICKEN MASALA',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0691','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(692,'CHICKEN TIKKA MASALA',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0692','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(693,'CHICKEN KADAI',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0693','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(694,'BUTTER CHICKEN MASALA',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0694','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(695,'CHICKEN CAPSICUM',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0695','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(696,'CHICKEN NURAI',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0696','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(697,'CHICKEN HARIYALI',1,'single',1,NULL,243,NULL,NULL,'exclusive',0,0,'AS0697','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(698,'MUTTON ROHAN JOSH',1,'single',1,NULL,244,NULL,NULL,'exclusive',0,0,'AS0698','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(699,'MUTTON ACHARI',1,'single',1,NULL,244,NULL,NULL,'exclusive',0,0,'AS0699','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(700,'MUTTON HARIYALI',1,'single',1,NULL,244,NULL,NULL,'exclusive',0,0,'AS0700','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(701,'MUTTON PEZHVARI',1,'single',1,NULL,244,NULL,NULL,'exclusive',0,0,'AS0701','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(702,'MUTTON KADAI',1,'single',1,NULL,244,NULL,NULL,'exclusive',0,0,'AS0702','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(703,'HOT AND SOUR VEG',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0703','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(704,'HOT AND SOUR CHICKEN',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0704','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(705,'NOODLES SOUP VEG',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0705','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(706,'NOODLES SOUP CHICKEN',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0706','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(707,'MANCHOW CHICKEN',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0707','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(708,'MANCHOW VEG',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0708','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(709,'CLEAR SOUP VEG',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0709','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(710,'CLEAR SOUP CHICKEN',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0710','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:36:25','2018-11-12 04:36:25'),(745,'SWEET CORN VEG',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0745','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(746,'SWEET CORN CHICKEN',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0746','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(747,'CREAM OF TOMATO SOUP',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0747','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(748,'LEMON CORIANDAR SOUP',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0748','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(749,'CREAM OF VEG/ MASHROOM',1,'single',1,NULL,245,NULL,NULL,'exclusive',0,0,'AS0749','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(750,'VEG',1,'single',1,NULL,252,NULL,NULL,'exclusive',0,0,'AS0750','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(751,'EGG',1,'single',1,NULL,252,NULL,NULL,'exclusive',0,0,'AS0751','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(752,'CHICKEN',1,'single',1,NULL,252,NULL,NULL,'exclusive',0,0,'AS0752','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(753,'BEEF',1,'single',1,NULL,252,NULL,NULL,'exclusive',0,0,'AS0753','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(754,'MIX',1,'single',1,NULL,252,NULL,NULL,'exclusive',0,0,'AS0754','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(755,'PRAWNS',1,'single',1,NULL,252,NULL,NULL,'exclusive',0,0,'AS0755','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(756,'VEG',1,'single',1,NULL,253,NULL,NULL,'exclusive',0,0,'AS0756','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(757,'EGG',1,'single',1,NULL,253,NULL,NULL,'exclusive',0,0,'AS0757','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(758,'CHICKEN',1,'single',1,NULL,253,NULL,NULL,'exclusive',0,0,'AS0758','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(759,'BEEF',1,'single',1,NULL,253,NULL,NULL,'exclusive',0,0,'AS0759','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(760,'MIX',1,'single',1,NULL,253,NULL,NULL,'exclusive',0,0,'AS0760','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(761,'PRAWNS',1,'single',1,NULL,253,NULL,NULL,'exclusive',0,0,'AS0761','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(762,'CHICKEN MANCHURIAN',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0762','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(763,'CHICKEN 65',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0763','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(764,'SWEET & SOUR CHICKEN',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0764','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(765,'CHILLY CHICKEN DRY/GRAVY',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0765','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(766,'SALT & PEPPER CHICKEN',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0766','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(767,'HOT & GARLIC CHICKEN',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0767','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:22'),(768,'GINGER CHICKEN',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0768','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:37:22','2018-11-12 04:37:23'),(779,'TANDOORI FISH(AVOLI)',1,'single',1,NULL,258,NULL,NULL,'exclusive',0,0,'AS0779','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(780,'TANDOORI FISH(PRAWNS)',1,'single',1,NULL,258,NULL,NULL,'exclusive',0,0,'AS0780','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(781,'MEEN VARATIYAD (MATHI)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0781','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(782,'MEEN VARATIYAD (AYALA)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0782','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(783,'MEEN VARATIYAD (CHEMEEN)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0783','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(784,'MEEN VARATIYAD (NETHOOLI)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0784','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(785,'MEEN POLLICHAD (AYAKOORA)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0785','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(786,'MEEN POLLICHAD (MATHI)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0786','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(787,'MEEN POLLICHAD (AYALA)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0787','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(788,'MEEN POLLICHAD (AVOLI)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0788','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(789,'MEEN POLLICHAD (CHERI)',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0789','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(790,'CHUTTA KOZIYUM KANNI',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0790','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(791,'KUNNI PATHIRI',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0791','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(792,'KAPPA BIRIYANI BEAF',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0792','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(793,'KAPPA BIRIYANI CHICKEN',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0793','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(794,'PUTTU BIRIYANI BEAF',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0794','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(795,'PUTTU BIRIYANI CHICKEN',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0795','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(796,'KOZHI NIRACHATH',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0796','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(797,'KANNI',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0797','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(798,'KAPPA',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0798','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(799,'FISH CURRY',1,'single',1,NULL,259,NULL,NULL,'exclusive',0,0,'AS0799','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:08','2018-11-12 04:38:08'),(810,'CHICKEN SCHEZWAN',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0810','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(811,'GOBI MANCHURIAN/CHILLY',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0811','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(812,'VEG MANCHURIAN',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0812','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(813,'CHICKEN LOLLYPOPE',1,'single',1,NULL,254,NULL,NULL,'exclusive',0,0,'AS0813','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(814,'LIME JUICE',1,'single',1,NULL,261,NULL,NULL,'exclusive',0,0,'AS0814','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(815,'LIME SODA',1,'single',1,NULL,261,NULL,NULL,'exclusive',0,0,'AS0815','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(816,'MANGO MILKSHAKE',1,'single',1,NULL,261,NULL,NULL,'exclusive',0,0,'AS0816','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(817,'MANGO MILKSHAKE',1,'single',1,NULL,261,NULL,NULL,'exclusive',0,0,'AS0817','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:38:54','2018-11-12 04:38:54'),(830,'MANGO MILKSHAKE',1,'single',1,NULL,261,NULL,NULL,'exclusive',0,0,'AS0830','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:41:09','2018-11-12 04:41:09'),(837,'MANGO MILKSHAKE',1,'variable',1,NULL,261,NULL,NULL,'exclusive',0,0,'AS0837','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:51:17','2018-11-12 04:51:17'),(842,'MANGO MILKSHAKE',1,'single',1,NULL,261,NULL,NULL,'exclusive',1,0,'AS0842','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:55:45','2018-11-12 04:55:45'),(843,'NANNARI SARBATH',1,'variable',1,NULL,261,NULL,NULL,'exclusive',1,0,'AS0843','C128',NULL,NULL,0,'','','','','',NULL,'',NULL,1,NULL,'2018-11-12 04:55:45','2018-11-12 04:55:45'),(844,'test',1,'single',1,1,1,NULL,NULL,'exclusive',1,1,'AS0844','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-14 22:11:13','2018-11-14 22:11:13'),(845,'pata gobi',1,'single',1,1,NULL,NULL,NULL,'exclusive',1,1,'AS0845','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-14 22:11:56','2018-11-14 22:11:56'),(846,'pata gobi',1,'single',1,1,NULL,NULL,NULL,'exclusive',1,1,'1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-14 22:12:47','2018-11-14 22:12:47'),(847,'test1234',1,'single',1,1,1,4,NULL,'exclusive',1,1,'AS0847','C128',NULL,NULL,0,NULL,'100',NULL,'1',NULL,NULL,NULL,NULL,1,NULL,'2018-11-14 23:12:24','2018-11-14 23:12:24'),(848,'test1234',1,'single',1,1,1,4,NULL,'exclusive',1,1,'AS0848','C128',NULL,NULL,0,NULL,'100',NULL,'1',NULL,NULL,NULL,NULL,1,NULL,'2018-11-14 23:12:24','2018-11-14 23:12:24'),(849,'testajax',1,'single',2,1,NULL,NULL,NULL,'exclusive',1,1,'AS0849','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-14 23:14:53','2018-11-14 23:14:53'),(850,'testajax',1,'single',2,1,NULL,NULL,NULL,'exclusive',1,1,'AS0850','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-14 23:14:53','2018-11-14 23:14:53'),(851,'testajaxtestajaxtestajax',1,'single',1,1,NULL,NULL,NULL,'exclusive',1,1,'AS0851','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-14 23:15:41','2018-11-14 23:15:41'),(852,'testtesttesttest',1,'single',1,1,NULL,NULL,NULL,'exclusive',1,1,'AS0852','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 00:44:54','2018-11-15 00:44:55'),(853,'testtesttesttest',1,'single',1,1,NULL,NULL,NULL,'exclusive',1,1,'AS0853','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 00:44:55','2018-11-15 00:44:55'),(854,'testtesttesttesttesttesttesttest',1,'single',1,1,1,4,NULL,'exclusive',1,1,'AS0854','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 00:46:28','2018-11-15 00:46:28'),(855,'testtesttesttesttesttesttesttest',1,'single',1,1,1,NULL,NULL,'exclusive',1,1,'AS0855','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 00:46:51','2018-11-15 00:46:51'),(856,'test1test1test1test1',1,'single',2,2,1,4,NULL,'exclusive',1,1,'AS0856','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 00:47:55','2018-11-15 00:47:55'),(857,'test1test1test1test1',1,'single',2,2,1,NULL,NULL,'exclusive',1,1,'AS0857','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 00:48:12','2018-11-15 00:48:12'),(858,'test1',1,'single',1,1,NULL,NULL,NULL,'exclusive',1,1,'AS0858','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 00:49:54','2018-11-15 00:49:54'),(859,'test1',1,'single',10,4,NULL,NULL,NULL,'exclusive',1,1,'AS0859','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 00:50:18','2018-11-15 00:50:18'),(860,'test',1,'single',1,1,NULL,NULL,NULL,'exclusive',1,1,'AS0860','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-15 01:07:01','2018-11-15 01:07:01'),(861,'test',6,'single',14,NULL,NULL,NULL,NULL,'exclusive',1,0,'test456','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12,NULL,'2018-11-23 10:49:22','2018-11-23 10:49:22'),(862,'lev',7,'single',15,NULL,NULL,NULL,NULL,'exclusive',1,1,'0862','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13,NULL,'2018-11-26 08:09:01','2018-11-26 08:09:02'),(863,'Rice 50 KG packet',1,'single',1,1,2,NULL,NULL,'exclusive',1,1,'AS0863','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-27 17:56:14','2018-11-27 17:56:14'),(864,'product 2',1,'single',1,1,1,NULL,NULL,'exclusive',0,0,'AS0864','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-11-27 17:56:42','2018-11-27 17:56:42'),(865,'WooCommerce single',9,'single',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'0865','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,655,'2018-11-30 07:56:26','2018-11-30 07:59:24'),(866,'Single 2',9,'single',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'0866','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,656,'2018-11-30 08:10:23','2018-11-30 08:10:50'),(868,'Var 2',9,'variable',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'0868','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,657,'2018-11-30 08:13:47','2018-11-30 08:14:21'),(869,'same-sku name',9,'single',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'same-sku','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,663,'2018-11-30 12:24:14','2018-11-30 12:24:28'),(870,'price-sku',9,'single',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'price-sku','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,664,'2018-11-30 12:25:39','2018-11-30 12:26:30'),(871,'variable stock',9,'variable',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'variable','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,665,'2018-11-30 12:34:06','2018-11-30 12:34:55'),(872,'variable stock2',9,'variable',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'variable2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,666,'2018-11-30 12:36:15','2018-11-30 12:36:38'),(873,'variable 3',9,'variable',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'variable3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,671,'2018-11-30 12:50:29','2018-11-30 12:50:54'),(874,'variablewithstock',9,'variable',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'variablewithstock','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,676,'2018-11-30 12:55:36','2018-11-30 12:56:08'),(875,'testvariation10',9,'variable',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'testvariation10','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,679,'2018-11-30 13:01:42','2018-11-30 13:02:50'),(876,'testvariation10stock',9,'variable',17,NULL,NULL,NULL,NULL,'exclusive',1,1,'testvariation10stock','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,682,'2018-11-30 13:04:07','2018-11-30 13:04:36'),(877,'Mobile',1,'single',2,1,NULL,NULL,NULL,'exclusive',1,1,'AS0877','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-12-03 22:07:26','2018-12-03 22:07:27'),(878,'Product lite',1,'single',1,1,1,4,1,'exclusive',1,1,'ProductProduct lite','C128',NULL,NULL,0,NULL,'1','1',NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-12-05 23:24:05','2018-12-05 23:24:05'),(879,'Product lite',1,'single',1,1,1,4,1,'exclusive',1,1,'ProductProduct lite','C128',NULL,NULL,0,NULL,'1','1',NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-12-05 23:24:06','2018-12-05 23:24:06'),(880,'Simple',1,'single',3,33,268,269,NULL,'inclusive',1,10,'SKU (Leave blank to auto generate sku)','C128',12.00,'months',0,NULL,'f1','f2',NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-12-06 19:30:32','2018-12-06 19:30:32'),(881,'BCBXHD2D1123455',1,'single',1,1,NULL,NULL,NULL,'exclusive',1,1,'BCBXHD2D1123455','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2018-12-06 23:30:53','2018-12-06 23:30:53');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `pp_without_discount` decimal(20,2) NOT NULL DEFAULT '0.00' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(20,2) DEFAULT NULL,
  `purchase_price_inc_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `item_tax` decimal(20,2) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `quantity_sold` decimal(20,4) DEFAULT '0.0000',
  `quantity_adjusted` decimal(20,4) DEFAULT '0.0000',
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pl_payment_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'due',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,2,2,100.0000,70.00,0.00,70.00,77.00,7.00,1,50.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-01-06 01:27:11','2018-12-13 12:58:42'),(2,1,2,3,150.0000,70.00,0.00,70.00,77.00,7.00,1,60.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-01-06 01:27:11','2018-12-13 12:58:42'),(3,1,2,4,150.0000,70.00,0.00,70.00,77.00,7.00,1,1.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-01-06 01:27:11','2018-12-13 12:58:42'),(4,1,2,5,150.0000,72.00,0.00,72.00,79.20,7.20,1,2.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-01-06 01:27:11','2018-12-13 12:58:42'),(5,1,2,6,100.0000,72.00,0.00,72.00,79.20,7.20,1,1.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-01-06 01:27:11','2018-12-13 12:58:42'),(6,2,14,47,100.0000,700.00,0.00,700.00,770.00,70.00,1,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-01-06 01:28:10','2018-12-13 12:58:42'),(8,4,21,64,200.0000,10.00,0.00,10.00,10.00,0.00,NULL,60.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-01-06 01:33:12','2018-12-13 12:58:43'),(9,5,27,70,500.0000,20.00,0.00,20.00,22.00,2.00,1,30.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-01-06 01:35:26','2018-12-13 12:58:43'),(10,11,34,77,50.0000,6.00,0.00,6.00,6.00,0.00,NULL,10.0000,0.0000,0.0000,'2018-04-10','2019-11-12',NULL,'paid','2018-04-10 04:48:16','2018-12-13 12:58:43'),(11,12,32,75,100.0000,12.00,0.00,12.00,12.00,0.00,NULL,7.0000,0.0000,0.0000,'2018-04-12','2019-05-12',NULL,'paid','2018-04-10 04:49:40','2018-12-13 12:58:43'),(12,13,36,79,150.0000,9.00,0.00,9.00,9.00,0.00,NULL,0.0000,0.0000,0.0000,'2018-03-30','2019-11-12',NULL,'paid','2018-04-10 04:50:41','2018-12-13 12:58:43'),(13,14,33,76,180.0000,12.00,0.00,12.00,12.00,0.00,NULL,27.0000,0.0000,0.0000,'2018-04-10','2018-11-10',NULL,'partial','2018-04-10 04:51:38','2018-12-13 12:58:43'),(20,37,61,104,20.0000,34.00,0.00,34.00,34.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-11 11:17:07','2018-12-13 12:58:43'),(21,37,64,107,200.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-11 11:17:07','2018-12-13 12:58:43'),(22,37,63,106,200.0000,10.00,0.00,10.00,10.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-11 11:17:07','2018-12-13 12:58:43'),(23,37,65,108,50.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-11 11:17:07','2018-12-13 12:58:43'),(24,38,17,57,30.0000,350.00,0.00,350.00,350.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 00:32:46'),(25,38,17,58,50.0000,350.00,0.00,350.00,350.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(26,38,64,107,100.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(27,38,15,49,30.0000,950.00,0.00,950.00,1045.00,95.00,1,1.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(28,38,15,50,20.0000,950.00,0.00,950.00,1045.00,95.00,1,1.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(29,38,15,51,30.0000,950.00,0.00,950.00,1045.00,95.00,1,1.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(30,38,15,52,20.0000,950.00,0.00,950.00,1045.00,95.00,1,1.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(31,38,15,53,40.0000,1010.00,0.00,1010.00,1111.00,101.00,1,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(32,38,18,59,20.0000,1350.00,0.00,1350.00,1350.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(33,38,18,60,20.0000,1450.00,0.00,1450.00,1450.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(34,38,63,106,100.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(35,38,19,61,30.0000,8.00,0.00,8.00,8.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(36,38,22,65,10.0000,8.00,0.00,8.00,8.80,0.80,1,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(37,38,24,67,10.0000,8.00,0.00,8.00,8.80,0.80,1,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(38,38,25,68,20.0000,15.00,0.00,15.00,15.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-06-12 17:48:04','2018-12-13 12:58:44'),(39,39,77,120,100.0000,3.00,0.00,3.00,3.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-07-13 02:04:45','2018-12-13 12:58:44'),(40,39,76,119,200.0000,8.00,0.00,8.00,8.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-07-13 02:04:45','2018-12-13 12:58:44'),(41,40,76,119,100.0000,8.00,0.00,8.00,8.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'due','2018-07-13 02:08:24','2018-12-13 12:58:44'),(42,45,861,909,10.0000,500.00,0.00,500.00,500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-23 10:49:23','2018-12-13 12:58:44'),(43,58,865,913,1.0000,100.00,0.00,100.00,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 07:56:41','2018-12-13 12:58:44'),(44,59,866,914,1.0000,100.00,0.00,100.00,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 08:11:14','2018-12-13 12:58:45'),(45,60,868,916,1.0000,100.00,0.00,100.00,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 08:15:32','2018-12-13 12:58:45'),(46,60,868,917,1.0000,120.00,0.00,120.00,120.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 08:15:32','2018-12-13 12:58:45'),(47,61,871,920,1.0000,120.00,0.00,120.00,120.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 12:34:31','2018-12-13 12:58:45'),(48,61,871,921,1.0000,15.00,0.00,15.00,15.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 12:34:31','2018-12-13 12:58:45'),(49,62,874,926,1.0000,102.00,0.00,102.00,102.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 12:55:56','2018-12-13 12:58:45'),(50,62,874,927,1.0000,150.00,0.00,150.00,150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 12:55:56','2018-12-13 12:58:45'),(51,63,876,930,1.0000,120.00,0.00,120.00,120.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 13:04:20','2018-12-13 12:58:45'),(52,63,876,931,1.0000,150.00,0.00,150.00,150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-11-30 13:04:20','2018-12-13 12:58:45'),(53,64,877,932,1.0000,100.00,0.00,100.00,100.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,'Lot 1','paid','2018-12-03 22:08:04','2018-12-13 12:58:45'),(54,64,877,932,100.0000,100.00,0.00,100.00,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,'Lot 2','paid','2018-12-03 22:09:17','2018-12-13 12:58:45'),(55,66,880,935,1.0000,100.00,0.00,100.00,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-12-06 19:30:33','2018-12-13 12:58:45'),(56,67,846,894,5.0000,100.00,0.00,100.00,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-12-06 19:51:59','2018-12-13 12:58:45'),(57,67,846,894,1.0000,100.00,0.00,100.00,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-12-06 19:56:42','2018-12-13 12:58:45'),(58,68,881,936,1.0000,100.00,0.00,100.00,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,'paid','2018-12-06 23:30:54','2018-12-13 12:58:46');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'purchase',1,1,'2018-06-11 16:47:07','2018-06-11 16:47:07'),(2,'contacts',8,1,'2018-06-11 16:47:07','2018-12-06 00:31:00'),(3,'contacts',2,5,'2018-07-13 11:12:11','2018-07-13 02:03:50'),(4,'business_location',1,5,'2018-07-13 11:12:11','2018-07-13 11:12:11'),(5,'purchase',2,5,'2018-07-13 02:04:45','2018-07-13 02:08:24'),(6,'sell_payment',4,5,'2018-07-13 02:14:40','2018-07-13 02:16:36'),(7,'contacts',1,6,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(8,'business_location',1,6,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(9,'contacts',2,7,'2018-11-26 07:53:58','2018-11-26 08:07:49'),(10,'business_location',1,7,'2018-11-26 07:53:59','2018-11-26 07:53:59'),(11,'purchase',1,7,'2018-11-26 08:12:35','2018-11-26 08:12:35'),(12,'purchase_payment',1,7,'2018-11-26 08:14:49','2018-11-26 08:14:49'),(13,'sell_payment',7,1,'2018-11-27 17:28:07','2018-12-13 00:33:30'),(14,'expense',4,1,'2018-11-27 17:29:13','2018-12-13 00:38:25'),(15,'expense_payment',1,1,'2018-11-27 17:47:03','2018-11-27 17:47:03'),(16,'purchase_payment',1,1,'2018-11-27 17:48:01','2018-11-27 17:48:01'),(17,'sell_return',1,1,'2018-11-27 17:59:03','2018-11-27 17:59:03'),(18,'contacts',1,8,'2018-11-28 06:31:01','2018-11-28 06:31:01'),(19,'business_location',1,8,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(20,'contacts',1,9,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(21,'business_location',1,9,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(22,'contacts',1,10,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(23,'business_location',1,10,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(24,'contacts',1,11,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(25,'business_location',1,11,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(26,'contacts',1,12,'2018-12-12 06:20:44','2018-12-12 06:20:44'),(27,'business_location',1,12,'2018-12-12 06:20:45','2018-12-12 06:20:45');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
INSERT INTO `res_product_modifier_sets` VALUES (78,72),(78,73),(79,73),(79,69),(79,72),(79,75),(79,68);
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
INSERT INTO `res_tables` VALUES (1,5,5,'Table 1',NULL,7,NULL,'2018-07-13 02:10:57','2018-07-13 02:10:57'),(2,5,5,'Table 2',NULL,7,NULL,'2018-07-13 02:11:04','2018-07-13 02:11:04'),(3,5,5,'Table 3',NULL,7,NULL,'2018-07-13 02:11:10','2018-07-13 02:11:10'),(4,5,5,'Table 4',NULL,7,NULL,'2018-07-13 02:11:17','2018-07-13 02:11:17');
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (35,2),(36,2),(37,2),(38,2),(67,2),(35,4),(36,4),(37,4),(38,4),(67,4),(35,8),(36,8),(37,8),(38,8),(67,8),(35,10),(36,10),(37,10),(38,10),(67,10),(67,11),(68,11),(35,13),(36,13),(37,13),(38,13),(67,13),(35,15),(36,15),(37,15),(38,15),(67,15),(35,17),(36,17),(37,17),(38,17),(67,17),(35,19),(36,19),(37,19),(38,19),(67,19),(35,21),(36,21),(37,21),(38,21),(67,21),(15,22),(16,22),(17,22),(18,22),(67,22),(68,22),(15,23),(16,23),(17,23),(18,23),(67,23),(68,23),(15,24),(16,24),(17,24),(18,24),(67,24),(68,24),(35,26),(36,26),(37,26),(38,26),(67,26),(35,28),(36,28),(37,28),(38,28),(67,28);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_service_staff` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2018-11-12 07:53:35','2018-11-12 07:53:35'),(2,'Cashier#1','web',1,0,0,'2018-11-12 07:53:36','2018-11-12 07:53:36'),(3,'Admin#2','web',2,1,0,'2018-11-12 07:53:38','2018-11-12 07:53:38'),(4,'Cashier#2','web',2,0,0,'2018-11-12 07:53:38','2018-11-12 07:53:38'),(7,'Admin#4','web',4,1,0,'2018-11-12 07:53:39','2018-11-12 07:53:39'),(8,'Cashier#4','web',4,0,0,'2018-11-12 07:53:39','2018-11-12 07:53:39'),(9,'Admin#5','web',5,1,0,'2018-11-12 07:53:39','2018-11-12 07:53:39'),(10,'Cashier#5','web',5,0,0,'2018-11-12 07:53:40','2018-11-12 07:53:40'),(11,'Waiter#5','web',5,0,1,'2018-11-12 07:53:40','2018-11-12 07:53:40'),(12,'Admin#6','web',6,1,0,'2018-11-23 10:35:53','2018-11-23 10:35:53'),(13,'Cashier#6','web',6,0,0,'2018-11-23 10:35:53','2018-11-23 10:35:53'),(14,'Admin#7','web',7,1,0,'2018-11-26 07:53:58','2018-11-26 07:53:58'),(15,'Cashier#7','web',7,0,0,'2018-11-26 07:53:58','2018-11-26 07:53:58'),(16,'Admin#8','web',8,1,0,'2018-11-28 06:31:01','2018-11-28 06:31:01'),(17,'Cashier#8','web',8,0,0,'2018-11-28 06:31:01','2018-11-28 06:31:01'),(18,'Admin#9','web',9,1,0,'2018-11-30 07:55:34','2018-11-30 07:55:34'),(19,'Cashier#9','web',9,0,0,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(20,'Admin#10','web',10,1,0,'2018-11-30 13:37:29','2018-11-30 13:37:29'),(21,'Cashier#10','web',10,0,0,'2018-11-30 13:37:30','2018-11-30 13:37:30'),(22,'New Role#1','web',1,0,0,'2018-12-06 00:14:22','2018-12-06 00:14:22'),(23,'New Role#1','web',1,0,0,'2018-12-06 00:14:23','2018-12-06 00:14:23'),(24,'new role 2#1','web',1,0,0,'2018-12-06 00:14:43','2018-12-06 00:14:43'),(25,'Admin#11','web',11,1,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(26,'Cashier#11','web',11,0,0,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(27,'Admin#12','web',12,1,0,'2018-12-12 06:20:43','2018-12-12 06:20:43'),(28,'Cashier#12','web',12,0,0,'2018-12-12 06:20:43','2018-12-12 06:20:43');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `business_id` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `unit_price` decimal(20,2) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `package_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `trial_end_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `package_price` decimal(20,2) NOT NULL,
  `package_details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_id` int(10) unsigned NOT NULL,
  `paid_via` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('approved','waiting','declined') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_business_id_foreign` (`business_id`),
  CONSTRAINT `subscriptions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (1,1,3,'2018-11-10','2018-11-20','2018-12-10',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\",\"woocommerce_module\":1}',1,'stripe','ch_1CuLdQAhokBpT93LVZNg2At6','approved',NULL,'2018-08-01 02:19:09','2018-08-01 02:19:09'),(2,2,3,'2018-11-10','2018-11-20','2018-12-10',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',4,'stripe','ch_1CuLggAhokBpT93LbaE29pMW','approved',NULL,'2018-08-01 04:22:31','2018-08-01 04:22:31'),(3,4,3,'2018-11-10','2018-11-20','2018-12-10',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',6,'stripe','ch_1CuLkoAhokBpT93LW0UAFC7N','approved',NULL,'2018-08-01 04:26:48','2018-08-01 04:26:48'),(5,5,3,'2018-11-10','2018-11-20','2018-12-10',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',7,'stripe','ch_1CuLmXAhokBpT93LOUCvEIKD','approved',NULL,'2018-08-01 04:28:34','2018-08-01 04:28:34'),(6,1,2,NULL,NULL,NULL,199.99,'{\"location_count\":2,\"user_count\":4,\"product_count\":1000,\"invoice_count\":800,\"name\":\"Regular\"}',1,'pesapal','0c7d43d1-5846-48c0-b82c-02c9cb98545a','waiting',NULL,'2018-11-21 23:49:58','2018-11-21 23:49:58'),(7,1,2,NULL,NULL,NULL,199.99,'{\"location_count\":2,\"user_count\":4,\"product_count\":1000,\"invoice_count\":800,\"name\":\"Regular\"}',1,'pesapal','0950b346-42fb-42c9-a695-cb37ad40e1b0','waiting',NULL,'2018-11-22 00:35:31','2018-11-22 00:35:31'),(8,1,2,NULL,NULL,NULL,199.99,'{\"location_count\":2,\"user_count\":4,\"product_count\":1000,\"invoice_count\":800,\"name\":\"Regular\"}',1,'pesapal','a72a5206-6034-425b-a133-a76ce1297283','waiting',NULL,'2018-11-22 00:59:40','2018-11-22 00:59:40'),(9,1,2,'2018-12-11','2019-01-21','2019-01-11',199.99,'{\"location_count\":2,\"user_count\":4,\"product_count\":1000,\"invoice_count\":800,\"name\":\"Regular\"}',1,'pesapal','64742602-aac9-4a00-83e7-a2f71e5623d4','approved',NULL,'2018-11-22 01:36:32','2018-11-22 14:36:43'),(10,1,3,'2019-01-12','2019-02-22','2019-02-12',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',1,'pesapal','65228c2c-e15a-4087-bd37-f4f33c5e3c56','approved',NULL,'2018-11-22 02:10:58','2018-11-22 14:41:33'),(11,1,2,'2019-02-13','2019-03-23','2019-03-13',199.99,'{\"location_count\":2,\"user_count\":4,\"product_count\":1000,\"invoice_count\":800,\"name\":\"Regular\"}',1,'offline','admin approval','approved',NULL,'2018-11-22 02:15:48','2018-11-22 14:46:57'),(12,6,2,NULL,NULL,NULL,199.99,'{\"location_count\":2,\"user_count\":4,\"product_count\":1000,\"invoice_count\":800,\"name\":\"Regular\"}',12,'pesapal','cbf2b75a-8b36-4adc-b674-f7f1d5f06181','waiting',NULL,'2018-11-23 10:37:31','2018-11-23 10:37:31'),(13,6,2,'2018-11-23','2019-01-02','2018-12-23',199.99,'{\"location_count\":2,\"user_count\":4,\"product_count\":1000,\"invoice_count\":800,\"name\":\"Regular\"}',12,'stripe','ch_1DZcAOAhokBpT93L2pVTM1Oz','approved',NULL,'2018-11-23 10:45:45','2018-11-23 10:45:45'),(14,7,1,'2018-11-26','2019-01-05','2018-12-26',0.00,'{\"location_count\":1,\"user_count\":2,\"product_count\":30,\"invoice_count\":30,\"name\":\"Starter - Free\"}',13,NULL,'FREE','approved',NULL,'2018-11-26 08:06:06','2018-11-26 08:06:06'),(15,9,1,'2018-11-30','2019-01-09','2018-12-30',0.00,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\",\"woocommerce_module\":1}',15,NULL,'FREE','approved',NULL,'2018-11-30 07:55:53','2018-11-30 07:55:53');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_communicator_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_communicator_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_ids` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_communicator_logs` WRITE;
/*!40000 ALTER TABLE `superadmin_communicator_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_communicator_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','2.10.1'),(2,'default_business_active_status','1'),(3,'superadmin_version','0.5'),(4,'app_currency_id','2'),(5,'invoice_business_name','Ultimate POS'),(6,'invoice_business_landmark','Linking Street'),(7,'invoice_business_zip','85001'),(8,'invoice_business_state','Arizona'),(9,'invoice_business_city','Phoenix'),(10,'invoice_business_country','USA'),(11,'email','thewebfosters@gmail.com'),(12,'package_expiry_alert_days','5'),(13,'enable_business_based_username','0'),(14,'account_version','0.1'),(15,'woocommerce_version','0.6.1'),(16,'superadmin_register_tc','I\'m testing terms & Conditions.\r\n\r\nI\'m testing terms & Conditions.\r\n\r\nI\'m testing terms & Conditions.'),(17,'superadmin_enable_register_tc','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(8,2) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_tax_rate_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
INSERT INTO `tax_rates` VALUES (1,1,'VAT@10%',10.00,0,1,NULL,NULL,'2018-01-03 21:10:07','2018-01-03 21:10:07'),(2,1,'CGST@10%',10.00,0,1,NULL,NULL,'2018-01-03 21:10:55','2018-01-03 21:10:55'),(3,1,'SGST@8%',8.00,0,1,NULL,NULL,'2018-01-03 21:11:13','2018-01-03 21:11:13'),(4,1,'GST@18%',18.00,1,1,NULL,NULL,'2018-01-03 21:12:19','2018-01-03 21:12:19');
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `payment_for` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,6,NULL,0,770.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,NULL,'2018-01-05 20:06:11','2018-01-05 20:06:11'),(2,7,NULL,0,825.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,NULL,'2018-01-05 20:06:31','2018-01-05 20:06:31'),(3,8,NULL,0,7700.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,NULL,'2018-01-05 20:07:23','2018-01-05 20:07:23'),(5,10,NULL,0,412.50,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,NULL,'2018-01-05 20:08:03','2018-01-05 20:08:03'),(6,4,NULL,0,2000.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:32:56',1,NULL,NULL,'Cash Payment',NULL,NULL,'2018-01-11 01:02:56','2018-01-11 01:02:56'),(7,3,NULL,0,3000.00,'bank_transfer',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,'502110000631','2018-01-11 17:34:10',1,NULL,NULL,'3000 Paid Via Bank Transfer',NULL,NULL,'2018-01-11 01:04:10','2018-01-11 01:04:10'),(8,2,NULL,0,84700.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:34:36',1,NULL,NULL,NULL,NULL,NULL,'2018-01-11 01:04:36','2018-01-11 01:04:36'),(9,1,NULL,0,50000.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:35:04',1,NULL,NULL,NULL,NULL,NULL,'2018-01-11 01:05:04','2018-01-11 01:05:04'),(10,1,NULL,0,5660.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:35:17',1,NULL,NULL,NULL,NULL,NULL,'2018-01-11 01:05:17','2018-01-11 01:05:17'),(11,11,NULL,0,300.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:48:47',4,8,NULL,NULL,NULL,NULL,'2018-04-10 04:48:47','2018-04-10 04:48:47'),(12,12,NULL,0,1200.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:49:49',4,9,NULL,NULL,NULL,NULL,'2018-04-10 04:49:49','2018-04-10 04:49:49'),(13,13,NULL,0,1350.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:50:55',4,9,NULL,NULL,NULL,NULL,'2018-04-10 04:50:55','2018-04-10 04:50:55'),(14,14,NULL,0,1500.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:52:10',4,9,NULL,NULL,NULL,NULL,'2018-04-10 04:52:10','2018-04-10 04:52:10'),(15,15,NULL,0,75.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:53:35',4,7,NULL,NULL,NULL,NULL,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(16,16,NULL,0,105.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:53:58',4,7,NULL,NULL,NULL,NULL,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(17,17,NULL,0,405.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:54:21',4,7,NULL,NULL,NULL,NULL,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(28,29,NULL,0,656.25,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:34:40',6,13,NULL,NULL,NULL,NULL,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(29,30,NULL,0,250.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:34:54',6,13,NULL,NULL,NULL,NULL,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(30,31,NULL,0,75.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:35:19',6,13,NULL,NULL,NULL,NULL,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(31,32,NULL,0,37.50,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:37:50',6,13,NULL,NULL,NULL,NULL,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(32,33,NULL,0,375.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:01',6,13,NULL,NULL,NULL,NULL,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(33,34,NULL,0,250.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:15',6,13,NULL,NULL,NULL,NULL,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(34,35,NULL,0,100.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:27',6,13,NULL,NULL,NULL,NULL,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(35,36,NULL,0,125.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:49',6,13,NULL,NULL,NULL,NULL,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(36,49,1,0,71.28,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-27 22:58:07',1,1,NULL,NULL,'SP2018/0001',NULL,'2018-11-27 17:28:07','2018-11-27 17:28:07'),(37,50,1,0,100.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-27 23:17:03',1,NULL,NULL,NULL,'2018/0001',NULL,'2018-11-27 17:47:04','2018-11-27 17:47:04'),(39,54,1,0,121.28,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-27 23:28:01',1,1,NULL,NULL,'SP2018/0002',NULL,'2018-11-27 17:58:01','2018-11-27 17:58:01'),(40,55,1,0,71.28,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-27 23:28:11',1,1,NULL,NULL,'SP2018/0003',NULL,'2018-11-27 17:58:11','2018-11-27 17:58:11'),(41,57,1,0,8680.50,'card',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-11-29 05:31:06',1,1,NULL,NULL,'SP2018/0004',NULL,'2018-11-29 00:01:06','2018-11-29 00:01:06'),(42,65,1,0,112.50,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2018-12-04 03:38:29',1,1,NULL,NULL,'SP2018/0005',NULL,'2018-12-03 22:08:29','2018-12-03 22:08:29'),(43,69,NULL,0,500.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-12-13 06:02:45',1,1,NULL,NULL,'SP2018/0006',NULL,'2018-12-13 00:32:45','2018-12-13 00:39:17'),(44,70,NULL,0,200.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-12-13 06:03:30',1,1,NULL,NULL,'SP2018/0007',NULL,'2018-12-13 00:33:30','2018-12-13 00:40:12');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `unit_price_before_discount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `unit_price` decimal(20,2) DEFAULT NULL,
  `line_discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_discount_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `unit_price_inc_tax` decimal(20,2) DEFAULT NULL,
  `item_tax` decimal(20,2) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text COLLATE utf8mb4_unicode_ci,
  `woocommerce_line_items_id` int(11) DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (1,6,2,3,10.0000,0.0000,70.00,70.00,NULL,0.00,77.00,7.00,1,NULL,NULL,NULL,NULL,'2018-01-06 01:36:11','2018-01-06 01:36:11'),(2,7,27,70,30.0000,0.0000,25.00,25.00,NULL,0.00,27.50,2.50,1,NULL,NULL,NULL,NULL,'2018-01-06 01:36:31','2018-01-06 01:36:31'),(3,8,2,3,50.0000,0.0000,70.00,70.00,NULL,0.00,77.00,7.00,1,NULL,NULL,NULL,NULL,'2018-01-06 01:37:23','2018-01-06 01:37:23'),(4,8,2,2,50.0000,0.0000,70.00,70.00,NULL,0.00,77.00,7.00,1,NULL,NULL,NULL,NULL,'2018-01-06 01:37:23','2018-01-06 01:37:23'),(5,9,21,64,60.0000,0.0000,12.50,12.50,NULL,0.00,12.50,0.00,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:37:45','2018-01-06 01:37:45'),(6,10,28,71,30.0000,0.0000,12.50,12.50,NULL,0.00,13.75,1.25,1,NULL,NULL,NULL,NULL,'2018-01-06 01:38:03','2018-01-06 01:38:03'),(7,15,34,77,10.0000,0.0000,7.50,7.50,NULL,0.00,7.50,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(8,16,32,75,7.0000,0.0000,15.00,15.00,NULL,0.00,15.00,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(9,17,33,76,27.0000,0.0000,15.00,15.00,NULL,0.00,15.00,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(15,29,53,96,5.0000,0.0000,131.25,131.25,NULL,0.00,131.25,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(16,30,51,94,2.0000,0.0000,125.00,125.00,NULL,0.00,125.00,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(17,31,57,100,3.0000,0.0000,25.00,25.00,NULL,0.00,25.00,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(18,32,60,103,2.0000,0.0000,18.75,18.75,NULL,0.00,18.75,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(19,33,56,99,2.0000,0.0000,187.50,187.50,NULL,0.00,187.50,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(20,34,54,97,20.0000,0.0000,12.50,12.50,NULL,0.00,12.50,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(21,35,55,98,10.0000,0.0000,10.00,10.00,NULL,0.00,10.00,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(22,36,57,100,5.0000,0.0000,25.00,25.00,NULL,0.00,25.00,0.00,NULL,NULL,'',NULL,NULL,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(23,41,71,114,2.0000,0.0000,21.25,21.25,NULL,0.00,21.25,0.00,NULL,NULL,'',NULL,NULL,'2018-07-13 02:14:40','2018-07-13 02:14:40'),(24,42,70,113,2.0000,0.0000,15.00,15.00,NULL,0.00,15.00,0.00,NULL,NULL,'',NULL,NULL,'2018-07-13 02:15:28','2018-07-13 02:15:28'),(25,42,67,110,2.0000,0.0000,10.00,10.00,NULL,0.00,10.00,0.00,NULL,NULL,'',NULL,NULL,'2018-07-13 02:15:28','2018-07-13 02:15:28'),(26,42,68,111,2.0000,0.0000,13.75,13.75,NULL,0.00,13.75,0.00,NULL,NULL,'',NULL,NULL,'2018-07-13 02:15:28','2018-07-13 02:15:28'),(27,43,74,117,1.0000,0.0000,8.75,8.75,NULL,0.00,8.75,0.00,NULL,NULL,'',NULL,NULL,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(28,43,73,116,1.0000,0.0000,25.00,25.00,NULL,0.00,25.00,0.00,NULL,NULL,'',NULL,NULL,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(29,44,74,117,3.0000,0.0000,8.75,8.75,NULL,0.00,8.75,0.00,NULL,NULL,'',NULL,NULL,'2018-07-13 02:16:36','2018-07-13 02:16:36'),(30,44,69,112,3.0000,0.0000,15.00,15.00,NULL,0.00,15.00,0.00,NULL,NULL,'',NULL,NULL,'2018-07-13 02:16:36','2018-07-13 02:16:36'),(31,47,17,57,1.0000,0.0000,437.50,437.50,'fixed',0.00,437.50,0.00,NULL,NULL,'',NULL,NULL,'2018-11-25 22:32:58','2018-11-25 22:32:58'),(32,48,2,4,1.0000,0.0000,70.00,70.00,'fixed',0.00,77.00,7.00,1,NULL,'',NULL,NULL,'2018-11-27 17:27:57','2018-11-27 17:27:57'),(33,49,2,6,1.0000,0.0000,72.00,72.00,'fixed',0.00,79.20,7.20,1,NULL,'',NULL,NULL,'2018-11-27 17:28:07','2018-11-27 17:28:07'),(34,53,864,912,5.0000,1.0000,125.00,125.00,'fixed',0.00,125.00,0.00,NULL,NULL,'',NULL,NULL,'2018-11-27 17:56:55','2018-11-27 17:59:04'),(35,54,2,5,1.0000,0.0000,72.00,72.00,'fixed',0.00,79.20,7.20,1,NULL,'',NULL,NULL,'2018-11-27 17:58:01','2018-11-27 17:58:01'),(36,55,2,5,1.0000,0.0000,72.00,72.00,'fixed',0.00,79.20,7.20,1,NULL,'',NULL,NULL,'2018-11-27 17:58:11','2018-11-27 17:58:11'),(37,57,17,57,1.0000,0.0000,437.50,437.50,'fixed',0.00,437.50,0.00,NULL,NULL,'',NULL,NULL,'2018-11-29 00:01:04','2018-11-29 00:01:04'),(38,57,17,58,1.0000,0.0000,437.50,437.50,'fixed',0.00,437.50,0.00,NULL,NULL,'',NULL,NULL,'2018-11-29 00:01:04','2018-11-29 00:01:04'),(39,57,675,723,1.0000,0.0000,6.25,6.25,'fixed',0.00,6.25,0.00,NULL,NULL,'',NULL,NULL,'2018-11-29 00:01:04','2018-11-29 00:01:04'),(40,57,679,727,1.0000,0.0000,6.25,6.25,'fixed',0.00,6.25,0.00,NULL,NULL,'',NULL,NULL,'2018-11-29 00:01:04','2018-11-29 00:01:04'),(41,57,677,725,1.0000,0.0000,6.25,6.25,'fixed',0.00,6.25,0.00,NULL,NULL,'',NULL,NULL,'2018-11-29 00:01:04','2018-11-29 00:01:04'),(42,57,15,50,1.0000,0.0000,1187.50,1187.50,'fixed',0.00,1306.25,118.75,1,NULL,'',NULL,NULL,'2018-11-29 00:01:04','2018-11-29 00:01:04'),(43,57,15,51,1.0000,0.0000,1187.50,1187.50,'fixed',0.00,1306.25,118.75,1,NULL,'',NULL,NULL,'2018-11-29 00:01:04','2018-11-29 00:01:04'),(44,57,15,52,1.0000,0.0000,1187.50,1187.50,'fixed',0.00,1306.25,118.75,1,NULL,'',NULL,NULL,'2018-11-29 00:01:04','2018-11-29 00:01:04'),(45,57,15,49,1.0000,0.0000,1187.50,1187.50,'fixed',0.00,1306.25,118.75,1,NULL,'',NULL,NULL,'2018-11-29 00:01:05','2018-11-29 00:01:05'),(46,57,18,59,1.0000,0.0000,1687.50,1687.50,'fixed',0.00,1687.50,0.00,NULL,NULL,'',NULL,NULL,'2018-11-29 00:01:05','2018-11-29 00:01:05'),(47,57,18,60,1.0000,0.0000,1812.50,1812.50,'fixed',0.00,1812.50,0.00,NULL,NULL,'',NULL,NULL,'2018-11-29 00:01:05','2018-11-29 00:01:05'),(48,57,63,106,1.0000,0.0000,12.50,12.50,'fixed',0.00,12.50,0.00,NULL,NULL,'',NULL,NULL,'2018-11-29 00:01:05','2018-11-29 00:01:05'),(49,57,28,71,1.0000,0.0000,12.50,12.50,'fixed',0.00,13.75,1.25,1,NULL,'',NULL,NULL,'2018-11-29 00:01:05','2018-11-29 00:01:05'),(50,65,877,932,1.0000,0.0000,125.00,125.00,'fixed',0.00,125.00,0.00,NULL,53,'',NULL,NULL,'2018-12-03 22:08:28','2018-12-03 22:08:28'),(51,69,17,57,1.0000,0.0000,500.00,500.00,'fixed',0.00,500.00,0.00,NULL,NULL,'',NULL,NULL,'2018-12-13 00:32:45','2018-12-13 00:39:17'),(52,70,677,725,1.0000,0.0000,200.00,200.00,'fixed',0.00,200.00,0.00,NULL,NULL,'',NULL,NULL,'2018-12-13 00:33:30','2018-12-13 00:40:12');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(20,4) NOT NULL,
  `qty_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (1,32,NULL,3,1.0000,0.0000,'2018-11-27 17:27:57','2018-11-27 17:27:57'),(2,33,NULL,5,1.0000,0.0000,'2018-11-27 17:28:07','2018-11-27 17:28:07'),(3,35,NULL,4,1.0000,0.0000,'2018-11-27 17:58:01','2018-11-27 17:58:01'),(4,36,NULL,4,1.0000,0.0000,'2018-11-27 17:58:11','2018-11-27 17:58:11'),(5,37,NULL,24,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(6,38,NULL,25,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(7,42,NULL,28,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(8,43,NULL,29,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(9,44,NULL,30,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(10,45,NULL,27,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(11,46,NULL,32,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(12,47,NULL,33,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(13,48,NULL,22,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(14,49,NULL,7,1.0000,0.0000,'2018-11-29 00:01:07','2018-11-29 00:01:07'),(15,50,NULL,53,1.0000,0.0000,'2018-12-03 22:08:30','2018-12-03 22:08:30'),(16,51,NULL,24,1.0000,0.0000,'2018-12-13 00:32:46','2018-12-13 00:32:46');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('purchase','sell','expense','stock_adjustment','sell_transfer','purchase_transfer','opening_stock','sell_return','opening_balance','purchase_return') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('received','pending','ordered','draft','final') COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT '0',
  `payment_status` enum('paid','due','partial') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_details` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_charges` decimal(20,2) NOT NULL DEFAULT '0.00',
  `additional_notes` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `final_total` decimal(20,2) NOT NULL DEFAULT '0.00',
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `expense_transaction_id` int(11) DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT '0',
  `is_suspend` tinyint(1) NOT NULL DEFAULT '0',
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `total_amount_recovered` decimal(20,2) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `delivery_status` enum('packaging','order_processing','delivered','pending_delivery') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `woocommerce_order_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,2,NULL,NULL,'35001BCVX','2018-10-28 13:23:27',50600.00,1,5060.00,NULL,'0',NULL,0.00,NULL,NULL,55660.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-01-06 01:27:11'),(2,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,5,NULL,NULL,'35001BJGN','2018-10-28 13:23:27',77000.00,1,7700.00,NULL,'0',NULL,0.00,NULL,NULL,84700.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:28:10','2018-01-06 01:28:10'),(3,1,1,NULL,NULL,NULL,'purchase','received',0,'partial',NULL,6,NULL,NULL,'35001BCVJ','2018-10-13 13:23:27',5489.00,1,550.00,NULL,'0',NULL,0.00,NULL,NULL,6039.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:32:22','2018-12-13 00:44:14'),(4,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,6,NULL,NULL,'35001BCVK','2018-10-13 13:23:27',2000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,2000.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:33:12','2018-01-06 01:33:12'),(5,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,6,NULL,NULL,'35001BCVD','2018-11-05 13:23:27',11000.00,1,1100.00,NULL,'0',NULL,0.00,NULL,NULL,12100.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:35:26','2018-01-06 01:35:26'),(6,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,4,NULL,'AS0001','','2018-04-10 13:23:21',770.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,770.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:36:11','2018-01-06 01:36:11'),(7,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0002','','2018-11-10 13:23:27',825.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,825.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:36:31','2018-01-06 01:36:31'),(8,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,4,NULL,'AS0003','','2018-11-10 13:23:27',7700.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,7700.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:37:22','2018-01-06 01:37:22'),(9,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0004','','2018-11-12 13:23:27',750.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,750.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:37:45','2018-11-23 00:13:43'),(10,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0005','','2018-11-12 13:23:27',412.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,412.50,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:38:03','2018-01-06 01:38:03'),(11,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,8,NULL,NULL,'56247065','2018-11-05 13:23:27',300.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,300.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:48:16','2018-04-10 04:48:47'),(12,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,9,NULL,NULL,'547887025','2018-11-05 13:23:27',1200.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1200.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:49:40','2018-04-10 04:49:49'),(13,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,9,NULL,NULL,'45470025','2018-10-13 13:23:27',1350.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1350.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:50:41','2018-04-10 04:50:55'),(14,2,2,NULL,NULL,NULL,'purchase','received',0,'partial',NULL,9,NULL,NULL,'65589898','2018-10-13 13:23:27',2160.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,2160.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:51:38','2018-04-10 04:52:10'),(15,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0001','','2018-11-10 13:23:27',75.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,75.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(16,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0002','','2018-11-10 13:23:27',105.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,105.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(17,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0003','','2018-11-12 13:23:27',405.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,405.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(29,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0001','','2018-11-12 13:23:27',656.25,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,656.25,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(30,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0002','','2018-11-10 13:23:27',250.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,250.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(31,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0003','','2018-11-12 13:23:27',75.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,75.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(32,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0004','','2018-11-12 13:23:27',37.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,37.50,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(33,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0005','','2018-11-10 13:23:27',375.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,375.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(34,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0006','','2018-11-10 13:23:27',250.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,250.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(35,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0007','','2018-11-12 13:23:27',100.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(36,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0008','','2018-11-10 13:23:27',125.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,125.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(37,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,6,NULL,NULL,'PO2018/0001','2018-11-10 13:23:27',5180.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,5180.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-06-11 16:47:07','2018-06-11 16:47:07'),(38,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,6,NULL,NULL,'PO2018/0002','2018-11-12 13:23:27',235656.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,235656.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-11-27 17:48:24'),(39,5,5,NULL,NULL,NULL,'purchase','received',0,'due',NULL,15,NULL,NULL,'PO2018/0001','2018-11-10 13:23:27',1900.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1900.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,'2018-07-13 02:04:45','2018-07-13 02:04:45'),(40,5,5,NULL,NULL,NULL,'purchase','received',0,'due',NULL,15,NULL,NULL,'PO2018/0002','2018-11-10 13:23:27',800.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,800.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,'2018-07-13 02:08:24','2018-07-13 02:08:24'),(41,5,5,1,8,'served','sell','final',0,'paid',NULL,14,NULL,'0001','','2018-11-12 13:23:27',42.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,42.50,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,'2018-07-13 02:14:40','2018-07-13 02:18:07'),(42,5,5,2,8,NULL,'sell','final',0,'paid',NULL,14,NULL,'0002','','2018-11-12 13:23:27',77.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,77.50,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,'2018-07-13 02:15:28','2018-07-13 02:15:29'),(43,5,5,3,8,NULL,'sell','final',0,'paid',NULL,14,NULL,'0003','','2018-11-12 13:23:27',33.75,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,33.75,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(44,5,5,NULL,NULL,'cooked','sell','final',0,'paid',NULL,14,NULL,'0004','','2018-11-12 13:23:27',71.25,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,71.25,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,'2018-07-13 02:16:36','2018-07-13 02:16:55'),(45,6,6,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:19:23',5000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,5000.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,861,12,NULL,NULL,NULL,NULL,NULL,'2018-11-23 10:49:23','2018-11-23 10:49:23'),(47,1,1,NULL,NULL,NULL,'sell','draft',0,NULL,NULL,1,NULL,'iqRrK','','2018-11-26 04:02:58',437.50,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,393.75,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,'2018-11-25 22:32:58','2018-11-25 22:32:58'),(48,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0006','','2018-11-27 22:57:57',77.00,NULL,0.00,'percentage','10',NULL,0.00,'Im testing',NULL,69.30,NULL,NULL,NULL,NULL,NULL,0,1,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,'2018-11-27 17:27:57','2018-11-27 17:27:57'),(49,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0007','','2018-11-27 22:58:07',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,'2018-11-27 17:28:07','2018-11-27 17:28:07'),(50,1,1,NULL,NULL,NULL,'expense','final',0,'paid',NULL,NULL,NULL,NULL,'Ref','2018-11-27 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'test',NULL,100.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-11-27 17:29:13','2018-11-27 17:47:04'),(51,1,1,NULL,NULL,NULL,'expense','final',0,'due',NULL,NULL,NULL,NULL,'exp2','2018-11-27 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,200.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-11-27 17:29:37','2018-11-27 17:29:37'),(52,1,1,NULL,NULL,NULL,'expense','final',0,'due',NULL,NULL,NULL,NULL,'exp3','2018-11-27 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,500.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-11-27 17:32:30','2018-11-27 17:32:30'),(53,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0008','','2018-11-27 23:26:55',625.00,NULL,0.00,'percentage','10',NULL,0.00,'suspended',NULL,562.50,NULL,NULL,NULL,NULL,NULL,0,1,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,'2018-11-27 17:56:55','2018-11-27 17:56:55'),(54,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0009','','2018-11-27 23:28:01',79.20,NULL,0.00,'percentage','10','courier',50.00,NULL,NULL,121.28,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,'2018-11-27 17:58:01','2018-11-27 17:58:01'),(55,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0010','','2018-11-27 23:28:11',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,'2018-11-27 17:58:11','2018-11-27 17:58:11'),(56,1,1,NULL,NULL,NULL,'sell_return','final',0,'due',NULL,1,NULL,'CN2018/0001',NULL,'2018-11-27 00:00:00',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,53,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-11-27 17:59:04','2018-11-27 17:59:04'),(57,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0011','','2018-11-29 05:31:02',9645.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,8680.50,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,'2018-11-29 00:01:03','2018-11-29 00:01:06'),(58,9,9,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:26:41',100.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,865,15,NULL,NULL,NULL,NULL,NULL,'2018-11-30 07:56:41','2018-11-30 07:56:41'),(59,9,9,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:41:14',100.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,866,15,NULL,NULL,NULL,NULL,NULL,'2018-11-30 08:11:14','2018-11-30 08:11:14'),(60,9,9,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:45:32',220.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,220.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,868,15,NULL,NULL,NULL,NULL,NULL,'2018-11-30 08:15:32','2018-11-30 08:15:32'),(61,9,9,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 18:04:30',135.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,135.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,871,15,NULL,NULL,NULL,NULL,NULL,'2018-11-30 12:34:31','2018-11-30 12:34:31'),(62,9,9,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 18:25:56',252.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,252.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,874,15,NULL,NULL,NULL,NULL,NULL,'2018-11-30 12:55:56','2018-11-30 12:55:56'),(63,9,9,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 18:34:20',270.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,270.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,876,15,NULL,NULL,NULL,NULL,NULL,'2018-11-30 13:04:20','2018-11-30 13:04:20'),(64,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 03:38:04',10100.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,10100.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,877,1,NULL,NULL,NULL,NULL,NULL,'2018-12-03 22:08:04','2018-12-03 22:09:17'),(65,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0012','','2018-12-04 03:38:28',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,'2018-12-03 22:08:28','2018-12-03 22:08:30'),(66,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 01:00:33',100.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,880,1,NULL,NULL,NULL,NULL,NULL,'2018-12-06 19:30:33','2018-12-06 19:30:33'),(67,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 01:21:59',600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,600.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,846,1,NULL,NULL,NULL,NULL,NULL,'2018-12-06 19:51:59','2018-12-06 19:56:42'),(68,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 05:00:54',100.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,881,1,NULL,NULL,NULL,NULL,NULL,'2018-12-06 23:30:54','2018-12-06 23:30:54'),(69,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0013','','2018-12-13 06:02:45',500.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,500.00,NULL,NULL,NULL,19,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,'delivered',NULL,NULL,NULL,NULL,'2018-12-13 00:32:45','2018-12-13 00:39:17'),(70,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0014','','2018-12-13 06:03:30',200.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,200.00,NULL,NULL,NULL,20,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,'delivered',NULL,NULL,NULL,NULL,'2018-12-13 00:33:30','2018-12-13 00:40:12'),(71,1,1,NULL,NULL,NULL,'expense','final',0,'paid',NULL,NULL,NULL,NULL,'REF','2018-12-13 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'test',NULL,10.00,NULL,19,70,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2018-12-13 00:38:25','2018-12-13 00:38:25');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Pieces','Pc(s)',0,1,NULL,'2018-01-03 15:15:20','2018-01-03 15:15:20'),(2,1,'Packets','packets',0,1,NULL,'2018-01-06 01:07:01','2018-01-06 01:08:36'),(3,1,'Grams','g',1,1,NULL,'2018-01-06 01:10:34','2018-01-06 01:10:34'),(4,2,'Pieces','Pc(s)',0,4,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(6,4,'Units','units',0,6,NULL,'2018-04-10 06:50:43','2018-04-10 07:02:04'),(7,5,'Pieces','Pc(s)',0,7,NULL,'2018-07-13 05:42:11','2018-07-13 05:42:11'),(8,5,'Packets','packets',0,7,NULL,'2018-07-12 20:27:16','2018-07-12 20:27:16'),(9,1,'unit1','unit1',1,1,NULL,'2018-11-14 22:37:05','2018-11-14 22:37:05'),(10,1,'unit1','unit1',1,1,NULL,'2018-11-14 22:37:05','2018-11-14 22:37:05'),(11,1,'unit1unit1','unit1unit1',1,1,NULL,'2018-11-14 22:37:31','2018-11-14 22:37:31'),(12,1,'unit1unit1','unit1unit1',1,1,NULL,'2018-11-14 22:37:31','2018-11-14 22:37:31'),(13,1,'unit1','unit1unit1',1,1,NULL,'2018-11-14 23:06:37','2018-11-14 23:06:37'),(14,6,'Pieces','Pc(s)',0,12,NULL,'2018-11-23 10:35:56','2018-11-23 10:35:56'),(15,7,'Pieces','Pc(s)',0,13,NULL,'2018-11-26 07:53:58','2018-11-26 07:53:58'),(16,8,'Pieces','Pc(s)',0,14,NULL,'2018-11-28 06:31:02','2018-11-28 06:31:02'),(17,9,'Pieces','Pc(s)',0,15,NULL,'2018-11-30 07:55:35','2018-11-30 07:55:35'),(18,10,'Pieces','Pc(s)',0,16,NULL,'2018-11-30 13:37:31','2018-11-30 13:37:31'),(19,11,'Pieces','Pc(s)',0,17,NULL,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(20,12,'Pieces','Pc(s)',0,18,NULL,'2018-12-12 06:20:44','2018-12-12 06:20:44');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_contact_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `surname` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `contact_no` char(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `status` enum('active','inactive','terminated') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT '0',
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `selected_contacts` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Mr','Admin',NULL,'admin','admin@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,'kB7WiR4zXcmzX1RSLbrRX28C22pV2PFxpDvx9CJesVygKJtLKfvQ5DICk8pZ',1,'active',0,0.00,0,NULL,'2018-01-03 20:45:19','2018-11-28 00:10:20'),(2,'Mr','Demo','Cashier','cashier','cashier@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,NULL,1,'active',0,0.00,0,NULL,'2018-01-03 20:50:58','2018-01-03 20:50:58'),(3,'Mr.','Demo','Admin','demo-admin','demoadmin@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,NULL,1,'active',0,0.00,0,NULL,'2018-01-06 01:40:57','2018-01-06 01:40:57'),(4,'Mr','Demo','Admin','admin-pharmacy','admin-pharma@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,'MJnleh4kefXZtw3FCI2yHKEwr45Rs5nZxyQyGSFRfjIcQn93sJZyw7BAzSUq',2,'active',0,0.00,0,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(6,'Mr','Demo','Admin','admin-services','admin-services@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,'CdBNjmTIXVU0nEgcEg85L97w6JEjvuE6CfF7mvhmz7Ad2K7IxJVd9WPLdxcg',4,'active',0,0.00,0,NULL,'2018-04-10 06:50:42','2018-04-10 06:50:42'),(7,'Mr','Demo','Admin','admin-restaurant','admin-restaurant@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,'ZzGDokwQe0vR0YpbBBWwbCWOGAkTgMS4wZlQOzAgWs2yAnovdGFkRwjofy1Y',5,'active',0,0.00,0,NULL,'2018-07-13 05:42:11','2018-07-13 05:42:11'),(8,'Mr','Kevin','Nicols','kevin-nicols','kevin@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,'57dRoj3knI8dJ9UPSqFo2EH0CVTco5WJHnDgrmB2CY4lvJR6ZTtmzHi7NdLa',5,'active',0,0.00,0,NULL,'2018-07-12 20:43:20','2018-07-12 20:43:20'),(9,'Mr.','Super','Admin','superadmin','superadmin@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,NULL,1,'active',0,0.00,0,NULL,'2018-08-01 22:35:55','2018-08-01 22:35:55'),(10,'Mr.','WooCommerce','User','woocommerce_user','woo@example.com','$2y$10$Fh2SQOdxsy43cY5vc5wNbOoEy/tJLze1hor6zSFnK4k1JLvQsc87a','en',NULL,NULL,NULL,1,'active',0,0.00,0,NULL,'2018-08-01 22:35:55','2018-08-01 22:35:55'),(11,'test','Nikhil','Agrawal','deb118602','nikhil_agrawal@live.com','$2y$10$QzgQxUynerYT1ys71.WY3eFNKbp1m2IvJ42aj7eaqXx3VHWY2JKN.','en',NULL,NULL,NULL,1,'active',0,0.00,0,'2018-12-01 05:03:41','2018-11-14 22:09:53','2018-12-01 05:03:41'),(12,'Pesapal','Pesapal','Pesapal','Pesapal','Pesapal@Pesapal.com','$2y$10$H0ux73/.dVsqG5lfzdztM.nyCBnt/jcX1HsENYIGxs0F7vtPMiVza','en',NULL,NULL,'C4ETO0TpuZpJ9fDmmVjzySzkvdXsIj5iKRF1AIq8qALM7RjeDZ6rIfUXKExo',6,'active',0,0.00,0,NULL,'2018-11-23 10:35:46','2018-11-23 10:35:52'),(13,'mr.','account','lastname','account','account@account.com','$2y$10$vXF9pVT00Vc7na4Siluw6.jAGn4d1Ydf6z6ImZxOSeOKsoYlCHnUK','en',NULL,NULL,NULL,7,'active',0,0.00,0,NULL,'2018-11-26 07:53:58','2018-11-26 07:53:58'),(14,'test','test','tetst','test456','test456@test456.com','$2y$10$Bo8d3.NFyCYszGDrvQn3eOMw7pwZwwOZwDDP9R1Qr3FPOIVR.FFFW','en',NULL,NULL,'g6NqpgKzQLDwODOVJc05mLObGWiavEvitfJPG0j8bCBtYlK5OeTFOeojaIC2',8,'active',0,0.00,0,NULL,'2018-11-28 06:31:00','2018-11-28 06:31:01'),(15,'t','t','t','test1234','test1234@test1234.com','$2y$10$OzyxqGig.IaNZjSFsqqtAuq1Jy0CLcVR1ROMq.AvAuO91u9O0Yn4i','en',NULL,NULL,'9w09Z9xh3O0btYhx95sjkIYBtJXQmWBrFATSVo3rwFt6nHb2WPjoqGlz7EzL',9,'active',0,0.00,0,NULL,'2018-11-30 07:55:34','2018-11-30 07:55:34'),(16,'t','t','t','testqwqw','testqwqw@testqwqw.com','$2y$10$pwx3OJrVDadabhU99kSL5uIZ9e/y4w.2mTP.IKUfe3QSveAWoBEju','en',NULL,NULL,'9dwQ21G5k7G8Y6iIt5W8J0IHJb0aFO0MckO2q91hudes6qJPvwvUj5Lpi2x2',10,'active',0,0.00,0,NULL,'2018-11-30 13:37:26','2018-11-30 13:37:27'),(17,'Prefix:','First Name:','Last Name:','username','email@email.com','$2y$10$tdOGXfHXp9NBuZ8IK3oVse3hmP8b1s4HiCUdK8jJIGoyehJEeFDNu','en',NULL,NULL,NULL,11,'active',0,0.00,0,NULL,'2018-12-11 08:10:02','2018-12-11 08:10:02'),(18,'test4567','test4567','test4567','test4567','test456@test456.com','$2y$10$d9DsXiu5TinTaOmIxqrV6eVxO3JkyvygwtQvtpbKbl9WEpn7j.Ww6','en',NULL,NULL,NULL,12,'active',0,0.00,0,NULL,'2018-12-12 06:20:42','2018-12-12 06:20:43'),(19,'mr.','Nikhil','Agrawal','5c12584cf39cb','nikhil_agrawal@live.com','DUMMY','en','9437638555','Road No.2',NULL,1,'active',1,20.00,0,NULL,'2018-12-13 00:32:04','2018-12-13 00:32:04'),(20,NULL,'sale 2',NULL,'5c12588a89751',NULL,'DUMMY','en',NULL,NULL,NULL,1,'active',1,30.00,0,NULL,'2018-12-13 00:33:06','2018-12-13 00:33:06');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_group_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int(10) unsigned NOT NULL,
  `price_group_id` int(10) unsigned NOT NULL,
  `price_inc_tax` decimal(20,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_group_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(20,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,2,2,2,1,50.0000,'2018-01-06 01:27:11','2018-01-06 01:37:23'),(2,2,2,3,1,90.0000,'2018-01-06 01:27:11','2018-01-06 01:37:23'),(3,2,2,4,1,149.0000,'2018-01-06 01:27:11','2018-11-27 17:27:57'),(4,2,2,5,1,148.0000,'2018-01-06 01:27:11','2018-11-27 17:58:11'),(5,2,2,6,1,99.0000,'2018-01-06 01:27:11','2018-11-27 17:28:07'),(6,14,15,47,1,100.0000,'2018-01-06 01:28:10','2018-01-06 01:28:10'),(7,28,30,71,1,469.0000,'2018-01-06 01:32:22','2018-11-29 00:01:06'),(8,21,23,64,1,140.0000,'2018-01-06 01:33:12','2018-01-06 01:37:45'),(9,27,29,70,1,470.0000,'2018-01-06 01:35:26','2018-01-06 01:36:32'),(10,34,36,77,2,40.0000,'2018-04-10 04:48:16','2018-04-10 04:53:35'),(11,32,34,75,2,93.0000,'2018-04-10 04:49:40','2018-04-10 04:53:58'),(12,36,38,79,2,150.0000,'2018-04-10 04:50:41','2018-04-10 04:50:41'),(13,33,35,76,2,153.0000,'2018-04-10 04:51:38','2018-04-10 04:54:21'),(20,61,63,104,1,20.0000,'2018-06-11 16:47:07','2018-06-11 16:47:07'),(21,64,66,107,1,300.0000,'2018-06-11 16:47:07','2018-06-12 17:48:04'),(22,63,65,106,1,299.0000,'2018-06-11 16:47:07','2018-11-29 00:01:06'),(23,65,67,108,1,50.0000,'2018-06-11 16:47:07','2018-06-11 16:47:07'),(24,17,19,57,1,28.0000,'2018-06-12 17:48:04','2018-12-13 00:32:45'),(25,17,19,58,1,49.0000,'2018-06-12 17:48:04','2018-11-29 00:01:06'),(26,15,16,49,1,29.0000,'2018-06-12 17:48:04','2018-11-29 00:01:06'),(27,15,16,50,1,19.0000,'2018-06-12 17:48:04','2018-11-29 00:01:06'),(28,15,16,51,1,29.0000,'2018-06-12 17:48:04','2018-11-29 00:01:06'),(29,15,17,52,1,19.0000,'2018-06-12 17:48:04','2018-11-29 00:01:06'),(30,15,17,53,1,40.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(31,18,20,59,1,19.0000,'2018-06-12 17:48:04','2018-11-29 00:01:06'),(32,18,20,60,1,19.0000,'2018-06-12 17:48:04','2018-11-29 00:01:06'),(33,19,21,61,1,30.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(34,22,24,65,1,10.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(35,24,26,67,1,10.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(36,25,27,68,1,20.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(37,77,79,120,5,100.0000,'2018-07-13 02:04:45','2018-07-13 02:04:45'),(38,76,78,119,5,300.0000,'2018-07-13 02:04:45','2018-07-13 02:08:24'),(39,861,863,909,6,10.0000,'2018-11-23 10:49:23','2018-11-23 10:49:23'),(40,862,864,910,7,0.0000,'2018-11-26 08:12:36','2018-11-26 08:16:39'),(41,865,867,913,9,1.0000,'2018-11-30 07:56:41','2018-11-30 07:56:41'),(42,866,868,914,9,1.0000,'2018-11-30 08:11:14','2018-11-30 08:11:14'),(43,868,870,916,9,1.0000,'2018-11-30 08:15:32','2018-11-30 08:15:32'),(44,868,870,917,9,1.0000,'2018-11-30 08:15:32','2018-11-30 08:15:32'),(45,871,873,920,9,1.0000,'2018-11-30 12:34:30','2018-11-30 12:34:30'),(46,871,873,921,9,1.0000,'2018-11-30 12:34:30','2018-11-30 12:34:30'),(47,874,876,926,9,1.0000,'2018-11-30 12:55:56','2018-11-30 12:55:56'),(48,874,876,927,9,1.0000,'2018-11-30 12:55:56','2018-11-30 12:55:56'),(49,876,878,930,9,1.0000,'2018-11-30 13:04:20','2018-11-30 13:04:20'),(50,876,878,931,9,1.0000,'2018-11-30 13:04:20','2018-11-30 13:04:20'),(51,877,879,932,1,100.0000,'2018-12-03 22:08:04','2018-12-03 22:09:17'),(52,880,882,935,1,1.0000,'2018-12-06 19:30:33','2018-12-06 19:30:33'),(53,846,848,894,1,6.0000,'2018-12-06 19:51:59','2018-12-06 19:56:42'),(54,881,883,936,1,1.0000,'2018-12-06 23:30:54','2018-12-06 23:30:54');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `woocommerce_attr_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
INSERT INTO `variation_templates` VALUES (1,'Size (Tshirts)',1,NULL,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(2,'Size (Shoes)',1,NULL,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(3,'Waist Size (Jeans)',1,NULL,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(4,'Color',1,NULL,'2018-01-06 07:12:52','2018-01-06 07:12:52'),(5,'Waist Size',1,NULL,'2018-11-12 07:53:40','2018-11-12 07:53:40'),(6,'Size',1,NULL,'2018-11-12 07:53:41','2018-11-12 07:53:41'),(7,'Internal Memory',1,NULL,'2018-11-12 07:53:44','2018-11-12 07:53:44'),(8,'Storage',1,NULL,'2018-11-12 07:53:46','2018-11-12 07:53:46'),(36,'Small',1,NULL,'2018-11-12 04:55:45','2018-11-12 04:55:45'),(37,'Size',9,34,'2018-11-30 08:13:16','2018-11-30 08:14:14');
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
INSERT INTO `variation_value_templates` VALUES (1,'S',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(2,'M',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(3,'L',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(4,'XL',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(5,'5',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(6,'6',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(7,'7',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(8,'8',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(9,'9',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(10,'28',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(11,'30',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(12,'32',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(13,'34',3,'2018-01-03 21:24:35','2018-01-03 21:24:35'),(14,'36',3,'2018-01-03 21:24:35','2018-01-03 21:24:35'),(16,'Black',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(17,'Blue',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(18,'Brown',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(19,'Grey',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(20,'Gold',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(21,'28',5,'2018-11-12 07:53:41','2018-11-12 07:53:41'),(22,'30',5,'2018-11-12 07:53:41','2018-11-12 07:53:41'),(23,'32',5,'2018-11-12 07:53:41','2018-11-12 07:53:41'),(24,'34',5,'2018-11-12 07:53:41','2018-11-12 07:53:41'),(25,'36',5,'2018-11-12 07:53:41','2018-11-12 07:53:41'),(26,'S',6,'2018-11-12 07:53:42','2018-11-12 07:53:42'),(27,'M',6,'2018-11-12 07:53:42','2018-11-12 07:53:42'),(28,'L',6,'2018-11-12 07:53:42','2018-11-12 07:53:42'),(29,'XL',6,'2018-11-12 07:53:42','2018-11-12 07:53:42'),(30,'6',6,'2018-11-12 07:53:42','2018-11-12 07:53:42'),(31,'7',6,'2018-11-12 07:53:42','2018-11-12 07:53:42'),(32,'8',6,'2018-11-12 07:53:43','2018-11-12 07:53:43'),(33,'9',6,'2018-11-12 07:53:43','2018-11-12 07:53:43'),(34,'5',6,'2018-11-12 07:53:43','2018-11-12 07:53:43'),(35,'Gray',4,'2018-11-12 07:53:44','2018-11-12 07:53:44'),(36,'64 GB',7,'2018-11-12 07:53:44','2018-11-12 07:53:44'),(37,'128 GB',7,'2018-11-12 07:53:45','2018-11-12 07:53:45'),(38,'White',4,'2018-11-12 07:53:45','2018-11-12 07:53:45'),(39,'32 GB',7,'2018-11-12 07:53:45','2018-11-12 07:53:45'),(40,'256 GB',8,'2018-11-12 07:53:46','2018-11-12 07:53:46'),(41,'500 GB',8,'2018-11-12 07:53:46','2018-11-12 07:53:46'),(69,'1',36,'2018-11-12 04:55:45','2018-11-12 04:55:45'),(70,'S',37,'2018-11-30 08:13:16','2018-11-30 08:13:16'),(71,'M',37,'2018-11-30 08:13:16','2018-11-30 08:13:16');
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `woocommerce_variation_id` int(11) DEFAULT NULL,
  `variation_value_id` int(11) DEFAULT NULL,
  `default_purchase_price` decimal(20,2) DEFAULT NULL,
  `dpp_inc_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `profit_percent` decimal(20,2) NOT NULL DEFAULT '0.00',
  `default_sell_price` decimal(20,2) DEFAULT NULL,
  `sell_price_inc_tax` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=937 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'AS0001',1,NULL,NULL,130.00,143.00,0.00,130.00,143.00,'2018-01-03 15:59:08','2018-06-11 02:10:59',NULL),(2,'28',2,'AS0002-1',2,NULL,21,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-11-12 07:53:41',NULL),(3,'30',2,'AS0002-2',2,NULL,22,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-11-12 07:53:41',NULL),(4,'32',2,'AS0002-3',2,NULL,23,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-11-12 07:53:41',NULL),(5,'34',2,'AS0002-4',2,NULL,24,72.00,79.20,0.00,72.00,79.20,'2018-01-03 16:00:35','2018-11-12 07:53:41',NULL),(6,'36',2,'AS0002-5',2,NULL,25,72.00,79.20,0.00,72.00,79.20,'2018-01-03 16:00:35','2018-11-12 07:53:41',NULL),(7,'S',3,'AS0003-1',3,NULL,26,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-11-12 07:53:42',NULL),(8,'M',3,'AS0003-2',3,NULL,27,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-11-12 07:53:42',NULL),(9,'L',3,'AS0003-3',3,NULL,28,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-11-12 07:53:42',NULL),(10,'XL',3,'AS0003-4',3,NULL,29,191.00,210.10,0.00,191.00,210.10,'2018-01-03 17:21:52','2018-11-12 07:53:42',NULL),(11,'6',4,'AS0004-1',4,NULL,30,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-11-12 07:53:42',NULL),(12,'7',4,'AS0004-2',4,NULL,31,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-11-12 07:53:43',NULL),(13,'8',4,'AS0004-3',4,NULL,32,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-11-12 07:53:43',NULL),(14,'9',4,'AS0004-4',4,NULL,33,166.00,182.60,0.00,166.00,182.60,'2018-01-03 17:24:34','2018-11-12 07:53:43',NULL),(27,'6',8,'AS0008-1',8,NULL,30,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-11-12 07:53:43',NULL),(28,'7',8,'AS0008-2',8,NULL,31,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-11-12 07:53:43',NULL),(29,'8',8,'AS0008-3',8,NULL,32,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-11-12 07:53:43',NULL),(30,'9',8,'AS0008-4',8,NULL,33,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-11-12 07:53:43',NULL),(31,'6',9,'AS0009-1',9,NULL,30,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-11-12 07:53:43',NULL),(32,'7',9,'AS0009-2',9,NULL,31,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-11-12 07:53:43',NULL),(33,'8',9,'AS0009-3',9,NULL,32,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-11-12 07:53:43',NULL),(34,'9',9,'AS0009-4',9,NULL,33,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-11-12 07:53:43',NULL),(35,'5',10,'AS0010-1',10,NULL,34,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-11-12 07:53:44',NULL),(36,'6',10,'AS0010-2',10,NULL,30,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-11-12 07:53:44',NULL),(37,'7',10,'AS0010-3',10,NULL,31,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-11-12 07:53:44',NULL),(38,'8',10,'AS0010-4',10,NULL,32,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-11-12 07:53:44',NULL),(39,'9',10,'AS0010-5',10,NULL,33,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-11-12 07:53:44',NULL),(40,'DUMMY',11,'AS0011',11,NULL,NULL,30.00,33.00,0.00,30.00,33.00,'2018-01-03 17:44:35','2018-06-11 02:06:08',NULL),(41,'DUMMY',12,'AS0012',12,NULL,NULL,25.00,27.50,0.00,25.00,27.50,'2018-01-03 17:45:50','2018-06-11 02:05:50',NULL),(42,'M',13,'AS0013-1',13,NULL,27,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-11-12 07:53:44',NULL),(43,'L',13,'AS0013-2',13,NULL,28,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-11-12 07:53:44',NULL),(44,'XL',13,'AS0013-3',13,NULL,29,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-11-12 07:53:44',NULL),(45,'Gray',14,'AS0014-1',14,NULL,35,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:12:19','2018-11-12 07:53:44',NULL),(46,'Black',14,'AS0014-2',14,NULL,16,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:12:19','2018-11-12 07:53:44',NULL),(47,'64 GB',14,'AS0014-1',15,NULL,36,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:14:14','2018-11-12 07:53:44',NULL),(48,'128 GB',14,'AS0014-2',15,NULL,37,800.00,880.00,25.00,1000.00,1100.00,'2018-01-06 00:14:14','2018-11-12 07:53:45',NULL),(49,'White',15,'AS0015-1',16,NULL,38,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-11-12 07:53:45',NULL),(50,'Gray',15,'AS0015-2',16,NULL,35,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-11-12 07:53:45',NULL),(51,'Black',15,'AS0015-3',16,NULL,16,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-11-12 07:53:45',NULL),(52,'32 GB',15,'AS0015-1',17,NULL,39,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-11-12 07:53:45',NULL),(53,'64 GB',15,'AS0015-2',17,NULL,36,1010.00,1111.00,25.00,1262.50,1388.75,'2018-01-06 00:19:51','2018-11-12 07:53:45',NULL),(54,'Gold',16,'AS0016-1',18,NULL,20,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-11-12 07:53:45',NULL),(55,'White',16,'AS0016-2',18,NULL,38,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-11-12 07:53:45',NULL),(56,'Black',16,'AS0016-3',18,NULL,16,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-11-12 07:53:45',NULL),(57,'Black',17,'AS0017-1',19,NULL,16,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:35:01','2018-11-12 07:53:46',NULL),(58,'White',17,'AS0017-2',19,NULL,38,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:35:01','2018-11-12 07:53:46',NULL),(59,'256 GB',18,'AS0018-1',20,NULL,40,1350.00,1350.00,25.00,1687.50,1687.50,'2018-01-06 00:37:30','2018-11-12 07:53:46',NULL),(60,'500 GB',18,'AS0018-2',20,NULL,41,1450.00,1450.00,25.00,1812.50,1812.50,'2018-01-06 00:37:30','2018-11-12 07:53:46',NULL),(61,'DUMMY',19,'AS0019',21,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-01-06 00:40:28','2018-06-11 02:08:23',NULL),(62,'Gray',20,'AS0020-1',22,NULL,35,25.00,27.50,25.00,31.25,34.38,'2018-01-06 00:43:00','2018-11-12 07:53:46',NULL),(63,'Black',20,'AS0020-2',22,NULL,16,25.00,27.50,25.00,31.25,34.38,'2018-01-06 00:43:00','2018-11-12 07:53:46',NULL),(64,'DUMMY',21,'AS0021',23,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-01-06 00:46:35','2018-06-11 02:12:13',NULL),(65,'DUMMY',22,'AS0022',24,NULL,NULL,8.00,8.80,25.00,10.00,11.00,'2018-01-06 00:55:09','2018-06-11 02:08:37',NULL),(66,'DUMMY',23,'AS0023',25,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-01-06 00:56:27','2018-06-11 02:13:51',NULL),(67,'DUMMY',24,'AS0024',26,NULL,NULL,8.00,8.80,25.00,10.00,11.00,'2018-01-06 01:01:22','2018-06-11 02:08:53',NULL),(68,'DUMMY',25,'AS0025',27,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-01-06 01:02:23','2018-06-11 02:09:09',NULL),(69,'DUMMY',26,'AS0026',28,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-01-06 01:05:51','2018-06-11 02:11:51',NULL),(70,'DUMMY',27,'AS0027',29,NULL,NULL,20.00,22.00,25.00,25.00,27.50,'2018-01-06 01:13:16','2018-06-11 02:08:01',NULL),(71,'DUMMY',28,'AS0028',30,NULL,NULL,10.00,11.00,25.00,12.50,13.75,'2018-01-06 01:15:47','2018-06-11 02:07:45',NULL),(72,'DUMMY',29,'AS0029',31,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-01-06 01:16:53','2018-06-11 02:14:34',NULL),(73,'DUMMY',30,'AS0030',32,NULL,NULL,40.00,44.00,25.00,50.00,55.00,'2018-01-06 01:18:59','2018-06-11 02:09:59',NULL),(74,'DUMMY',31,'AP0031',33,NULL,NULL,7.00,7.00,25.00,8.75,8.75,'2018-04-10 04:36:29','2018-04-10 04:36:29',NULL),(75,'DUMMY',32,'AP0032',34,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-04-10 04:37:52','2018-04-10 04:37:52',NULL),(76,'DUMMY',33,'AP0033',35,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-04-10 04:39:45','2018-04-10 04:39:45',NULL),(77,'DUMMY',34,'AP0034',36,NULL,NULL,6.00,6.00,25.00,7.50,7.50,'2018-04-10 04:40:59','2018-04-10 04:40:59',NULL),(78,'DUMMY',35,'AP0035',37,NULL,NULL,7.00,7.00,25.00,8.75,8.75,'2018-04-10 04:42:53','2018-04-10 04:42:53',NULL),(79,'DUMMY',36,'AP0036',38,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-04-10 04:44:18','2018-04-10 04:44:18',NULL),(80,'DUMMY',37,'AP0037',39,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-04-10 05:01:29','2018-04-10 05:01:29',NULL),(81,'DUMMY',38,'AP0038',40,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-04-10 05:02:35','2018-04-10 05:02:35',NULL),(82,'DUMMY',39,'AP0039',41,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-04-10 05:03:26','2018-04-10 05:03:26',NULL),(83,'DUMMY',40,'AP0040',42,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-04-10 05:04:32','2018-04-10 05:04:49',NULL),(94,'DUMMY',51,'AS0051',53,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-04-10 07:04:57','2018-04-10 07:04:57',NULL),(95,'DUMMY',52,'AS0052',54,NULL,NULL,80.00,80.00,25.00,100.00,100.00,'2018-04-10 07:05:55','2018-04-10 07:05:55',NULL),(96,'DUMMY',53,'AS0053',55,NULL,NULL,105.00,105.00,25.00,131.25,131.25,'2018-04-10 07:09:15','2018-04-10 07:09:15',NULL),(97,'DUMMY',54,'AS0054',56,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-04-10 07:24:16','2018-04-10 07:24:16',NULL),(98,'DUMMY',55,'AS0055',57,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-04-10 07:26:18','2018-04-10 07:26:18',NULL),(99,'DUMMY',56,'AS0056',58,NULL,NULL,150.00,150.00,25.00,187.50,187.50,'2018-04-10 07:31:59','2018-04-10 07:31:59',NULL),(100,'DUMMY',57,'AS0057',59,NULL,NULL,20.00,20.00,25.00,25.00,25.00,'2018-04-10 07:33:01','2018-04-10 07:33:01',NULL),(101,'DUMMY',58,'AS0058',60,NULL,NULL,20.00,20.00,25.00,25.00,25.00,'2018-04-10 07:33:37','2018-04-10 07:33:37',NULL),(102,'DUMMY',59,'AS0059',61,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-04-10 07:36:45','2018-04-10 07:36:45',NULL),(103,'DUMMY',60,'AS0060',62,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-04-10 07:37:08','2018-04-10 07:37:08',NULL),(104,'DUMMY',61,'AS0061',63,NULL,NULL,34.00,34.00,25.00,42.50,42.50,'2018-06-11 16:27:41','2018-06-11 16:27:41',NULL),(105,'DUMMY',62,'AS0062',64,NULL,NULL,35.00,35.00,25.00,43.75,43.75,'2018-06-11 16:32:17','2018-06-11 16:32:17',NULL),(106,'DUMMY',63,'AS0063',65,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-06-11 16:38:12','2018-06-11 16:38:12',NULL),(107,'DUMMY',64,'AS0064',66,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-06-11 16:40:34','2018-06-11 16:40:34',NULL),(108,'DUMMY',65,'AS0065',67,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-06-11 16:44:00','2018-06-11 16:44:30',NULL),(109,'DUMMY',66,'AR0066',68,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-07-13 01:00:31','2018-07-13 01:00:31',NULL),(110,'DUMMY',67,'AR0067',69,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-07-13 01:04:47','2018-07-13 01:04:47',NULL),(111,'DUMMY',68,'AR0068',70,NULL,NULL,11.00,11.00,25.00,13.75,13.75,'2018-07-13 01:08:55','2018-07-13 01:08:55',NULL),(112,'DUMMY',69,'AR0069',71,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-07-13 01:15:51','2018-07-13 01:15:51',NULL),(113,'DUMMY',70,'AR0070',72,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-07-13 01:27:37','2018-07-13 01:27:37',NULL),(114,'DUMMY',71,'AR0071',73,NULL,NULL,17.00,17.00,25.00,21.25,21.25,'2018-07-13 01:30:41','2018-07-13 01:30:41',NULL),(115,'DUMMY',72,'AR0072',74,NULL,NULL,18.00,18.00,25.00,22.50,22.50,'2018-07-13 01:35:03','2018-07-13 01:35:03',NULL),(116,'DUMMY',73,'AR0073',75,NULL,NULL,20.00,20.00,25.00,25.00,25.00,'2018-07-13 01:37:29','2018-07-13 01:37:29',NULL),(117,'DUMMY',74,'AR0074',76,NULL,NULL,7.00,7.00,25.00,8.75,8.75,'2018-07-13 01:40:45','2018-07-13 01:40:45',NULL),(118,'DUMMY',75,'AR0075',77,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-07-13 01:43:09','2018-07-13 01:43:09',NULL),(119,'DUMMY',76,'AR0076',78,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-07-13 01:48:33','2018-07-13 01:48:33',NULL),(120,'DUMMY',77,'AR0077',79,NULL,NULL,3.00,3.00,25.00,3.75,3.75,'2018-07-13 01:54:22','2018-07-13 01:58:56',NULL),(121,'Bacon',78,'AR0078-1',80,NULL,NULL,2.00,2.00,0.00,2.00,2.00,'2018-07-16 02:28:04','2018-07-16 02:28:51',NULL),(122,'Black olives',78,'AR0078-2',80,NULL,NULL,1.00,1.00,0.00,1.00,1.00,'2018-07-16 02:28:33','2018-07-16 02:28:51',NULL),(123,'Green peppers',78,'AR0078-3',80,NULL,NULL,1.00,1.00,0.00,1.00,1.00,'2018-07-16 02:28:51','2018-07-16 02:28:51',NULL),(124,'Cheese',79,'AR0079-1',81,NULL,NULL,2.00,2.00,0.00,2.00,2.00,'2018-07-16 02:35:37','2018-07-16 02:36:52',NULL),(125,'Vegies',79,'AR0079-2',81,NULL,NULL,1.00,1.00,0.00,1.00,1.00,'2018-07-16 02:35:37','2018-07-16 02:36:52',NULL),(126,'Bacon',79,'AR0079-3',81,NULL,NULL,2.00,2.00,0.00,2.00,2.00,'2018-07-16 02:35:37','2018-07-16 02:36:52',NULL),(127,'Chocolate',79,'AR0079-4',81,NULL,NULL,2.00,2.00,0.00,2.00,2.00,'2018-07-16 02:36:52','2018-07-16 02:36:52',NULL),(128,'DUMMY',80,'AS0080',82,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-12 03:58:25','2018-11-12 03:58:25',NULL),(129,'DUMMY',81,'AS0081',83,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-12 03:58:57','2018-11-12 03:58:57',NULL),(710,'DUMMY',662,'AS0662',664,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(711,'DUMMY',663,'AS0663',665,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(712,'DUMMY',664,'AS0664',666,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(713,'DUMMY',665,'AS0665',667,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(714,'DUMMY',666,'AS0666',668,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(715,'DUMMY',667,'AS0667',669,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(716,'DUMMY',668,'AS0668',670,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(717,'DUMMY',669,'AS0669',671,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(718,'DUMMY',670,'AS0670',672,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(719,'DUMMY',671,'AS0671',673,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(720,'DUMMY',672,'AS0672',674,NULL,NULL,7.00,7.00,25.00,8.75,8.75,'2018-11-12 04:36:24','2018-11-12 04:36:24',NULL),(721,'DUMMY',673,'AS0673',675,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(722,'DUMMY',674,'AS0674',676,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(723,'DUMMY',675,'AS0675',677,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(724,'DUMMY',676,'AS0676',678,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(725,'DUMMY',677,'AS0677',679,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(726,'DUMMY',678,'AS0678',680,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(727,'DUMMY',679,'AS0679',681,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(728,'DUMMY',680,'AS0680',682,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(729,'DUMMY',681,'AS0681',683,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(730,'DUMMY',682,'AS0682',684,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(731,'DUMMY',683,'AS0683',685,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(732,'DUMMY',684,'AS0684',686,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(733,'DUMMY',685,'AS0685',687,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(734,'DUMMY',686,'AS0686',688,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(735,'DUMMY',687,'AS0687',689,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(736,'DUMMY',688,'AS0688',690,NULL,NULL,5.00,5.00,25.00,6.25,6.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(737,'DUMMY',689,'AS0689',691,NULL,NULL,28.00,28.00,25.00,35.00,35.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(738,'DUMMY',690,'AS0690',692,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(739,'DUMMY',691,'AS0691',693,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(740,'DUMMY',692,'AS0692',694,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(741,'DUMMY',693,'AS0693',695,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(742,'DUMMY',694,'AS0694',696,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(743,'DUMMY',695,'AS0695',697,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(744,'DUMMY',696,'AS0696',698,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(745,'DUMMY',697,'AS0697',699,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(746,'DUMMY',698,'AS0698',700,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(747,'DUMMY',699,'AS0699',701,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(748,'DUMMY',700,'AS0700',702,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(749,'DUMMY',701,'AS0701',703,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(750,'DUMMY',702,'AS0702',704,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(751,'DUMMY',703,'AS0703',705,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(752,'DUMMY',704,'AS0704',706,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(753,'DUMMY',705,'AS0705',707,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(754,'DUMMY',706,'AS0706',708,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(755,'DUMMY',707,'AS0707',709,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(756,'DUMMY',708,'AS0708',710,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(757,'DUMMY',709,'AS0709',711,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(758,'DUMMY',710,'AS0710',712,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:36:25','2018-11-12 04:36:25',NULL),(793,'DUMMY',745,'AS0745',747,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(794,'DUMMY',746,'AS0746',748,NULL,NULL,9.00,9.00,25.00,11.25,11.25,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(795,'DUMMY',747,'AS0747',749,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(796,'DUMMY',748,'AS0748',750,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(797,'DUMMY',749,'AS0749',751,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(798,'DUMMY',750,'AS0750',752,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(799,'DUMMY',751,'AS0751',753,NULL,NULL,11.00,11.00,25.00,13.75,13.75,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(800,'DUMMY',752,'AS0752',754,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(801,'DUMMY',753,'AS0753',755,NULL,NULL,13.00,13.00,25.00,16.25,16.25,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(802,'DUMMY',754,'AS0754',756,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(803,'DUMMY',755,'AS0755',757,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(804,'DUMMY',756,'AS0756',758,NULL,NULL,11.00,11.00,25.00,13.75,13.75,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(805,'DUMMY',757,'AS0757',759,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(806,'DUMMY',758,'AS0758',760,NULL,NULL,13.00,13.00,25.00,16.25,16.25,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(807,'DUMMY',759,'AS0759',761,NULL,NULL,14.00,14.00,25.00,17.50,17.50,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(808,'DUMMY',760,'AS0760',762,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(809,'DUMMY',761,'AS0761',763,NULL,NULL,15.00,15.00,25.00,18.75,18.75,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(810,'DUMMY',762,'AS0762',764,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(811,'DUMMY',763,'AS0763',765,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(812,'DUMMY',764,'AS0764',766,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(813,'DUMMY',765,'AS0765',767,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(814,'DUMMY',766,'AS0766',768,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(815,'DUMMY',767,'AS0767',769,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:22','2018-11-12 04:37:22',NULL),(816,'DUMMY',768,'AS0768',770,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:37:23','2018-11-12 04:37:23',NULL),(827,'DUMMY',779,'AS0779',781,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(828,'DUMMY',780,'AS0780',782,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(829,'DUMMY',781,'AS0781',783,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(830,'DUMMY',782,'AS0782',784,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(831,'DUMMY',783,'AS0783',785,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(832,'DUMMY',784,'AS0784',786,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(833,'DUMMY',785,'AS0785',787,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(834,'DUMMY',786,'AS0786',788,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(835,'DUMMY',787,'AS0787',789,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(836,'DUMMY',788,'AS0788',790,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(837,'DUMMY',789,'AS0789',791,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(838,'DUMMY',790,'AS0790',792,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(839,'DUMMY',791,'AS0791',793,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(840,'DUMMY',792,'AS0792',794,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(841,'DUMMY',793,'AS0793',795,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(842,'DUMMY',794,'AS0794',796,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(843,'DUMMY',795,'AS0795',797,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(844,'DUMMY',796,'AS0796',798,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(845,'DUMMY',797,'AS0797',799,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(846,'DUMMY',798,'AS0798',800,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(847,'DUMMY',799,'AS0799',801,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-12 04:38:08','2018-11-12 04:38:08',NULL),(858,'DUMMY',810,'AS0810',812,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:38:54','2018-11-12 04:38:54',NULL),(859,'DUMMY',811,'AS0811',813,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-11-12 04:38:54','2018-11-12 04:38:54',NULL),(860,'DUMMY',812,'AS0812',814,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-11-12 04:38:54','2018-11-12 04:38:54',NULL),(861,'DUMMY',813,'AS0813',815,NULL,NULL,12.00,12.00,25.00,15.00,15.00,'2018-11-12 04:38:54','2018-11-12 04:38:54',NULL),(862,'DUMMY',814,'AS0814',816,NULL,NULL,4.00,4.00,25.00,5.00,5.00,'2018-11-12 04:38:54','2018-11-12 04:38:54',NULL),(863,'DUMMY',815,'AS0815',817,NULL,NULL,4.00,4.00,25.00,5.00,5.00,'2018-11-12 04:38:54','2018-11-12 04:38:54',NULL),(864,'DUMMY',816,'AS0816',818,NULL,NULL,6.00,6.00,25.00,7.50,7.50,'2018-11-12 04:38:54','2018-11-12 04:38:54',NULL),(865,'DUMMY',817,'AS0817',819,NULL,NULL,8.00,8.00,25.00,10.00,10.00,'2018-11-12 04:38:54','2018-11-12 04:38:54',NULL),(878,'DUMMY',830,'AS0830',832,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-11-12 04:41:09','2018-11-12 04:41:09',NULL),(885,'S',837,'AS0837-1',839,NULL,26,10.00,10.00,25.00,12.50,12.50,'2018-11-12 04:51:17','2018-11-12 04:51:17',NULL),(890,'DUMMY',842,'AS0842',844,NULL,NULL,10.00,10.00,25.00,12.50,12.50,'2018-11-12 04:55:45','2018-11-12 04:55:45',NULL),(891,'1',843,'AS0843-1',845,NULL,69,4.00,4.00,25.00,5.00,5.00,'2018-11-12 04:55:45','2018-11-12 04:55:45',NULL),(892,'DUMMY',844,'AS0844',846,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-14 22:11:13','2018-11-14 22:11:13',NULL),(893,'DUMMY',845,'AS0845',847,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-14 22:11:56','2018-11-14 22:11:56',NULL),(894,'DUMMY',846,'1',848,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-14 22:12:47','2018-11-14 22:12:47',NULL),(895,'DUMMY',847,'AS0847',849,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-14 23:12:24','2018-11-14 23:12:24',NULL),(896,'DUMMY',848,'AS0848',850,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-14 23:12:24','2018-11-14 23:12:24',NULL),(897,'DUMMY',849,'AS0849',851,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-14 23:14:53','2018-11-14 23:14:53',NULL),(898,'DUMMY',850,'AS0850',852,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-14 23:14:53','2018-11-14 23:14:53',NULL),(899,'DUMMY',851,'AS0851',853,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-14 23:15:41','2018-11-14 23:15:41',NULL),(900,'DUMMY',853,'AS0853',855,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-15 00:44:56','2018-11-15 00:44:56',NULL),(901,'DUMMY',852,'AS0852',854,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-15 00:44:56','2018-11-15 00:44:56',NULL),(902,'DUMMY',854,'AS0854',856,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-15 00:46:28','2018-11-15 00:46:28',NULL),(903,'DUMMY',855,'AS0855',857,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-15 00:46:51','2018-11-15 00:46:51',NULL),(904,'DUMMY',856,'AS0856',858,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-15 00:47:55','2018-11-15 00:47:55',NULL),(905,'DUMMY',857,'AS0857',859,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-15 00:48:12','2018-11-15 00:48:12',NULL),(906,'DUMMY',858,'AS0858',860,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-15 00:49:54','2018-11-15 00:49:54',NULL),(907,'DUMMY',859,'AS0859',861,NULL,NULL,1.00,1.00,25.00,1.25,1.25,'2018-11-15 00:50:18','2018-11-15 00:50:18',NULL),(908,'DUMMY',860,'AS0860',862,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-15 01:07:01','2018-11-15 01:07:01',NULL),(909,'DUMMY',861,'test456',863,NULL,NULL,500.00,500.00,25.00,625.00,625.00,'2018-11-23 10:49:23','2018-11-23 10:49:23',NULL),(910,'DUMMY',862,'0862',864,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-26 08:09:03','2018-11-26 08:09:03',NULL),(911,'DUMMY',863,'AS0863',865,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-27 17:56:15','2018-11-27 17:56:15',NULL),(912,'DUMMY',864,'AS0864',866,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-27 17:56:42','2018-11-27 17:56:42',NULL),(913,'DUMMY',865,'0865',867,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-30 07:56:26','2018-11-30 07:56:26',NULL),(914,'DUMMY',866,'0866',868,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-30 08:10:23','2018-11-30 08:10:23',NULL),(916,'S',868,'0868-1',870,658,70,100.00,100.00,25.00,125.00,125.00,'2018-11-30 08:13:47','2018-11-30 08:15:47',NULL),(917,'M',868,'0868-2',870,659,71,120.00,120.00,25.00,150.00,150.00,'2018-11-30 08:13:47','2018-11-30 08:15:47',NULL),(918,'DUMMY',869,'same-sku',871,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-30 12:24:14','2018-11-30 12:24:14',NULL),(919,'DUMMY',870,'price-sku',872,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-11-30 12:25:39','2018-11-30 12:25:39',NULL),(920,'S',871,'variable-1',873,667,70,120.00,120.00,25.00,150.00,150.00,'2018-11-30 12:34:06','2018-11-30 12:38:03',NULL),(921,'M',871,'variable-2',873,668,71,15.00,15.00,25.00,18.75,18.75,'2018-11-30 12:34:06','2018-11-30 12:38:03',NULL),(922,'S',872,'variable2-1',874,669,70,150.00,150.00,25.00,187.50,187.50,'2018-11-30 12:36:15','2018-11-30 12:38:10',NULL),(923,'M',872,'variable2-2',874,670,71,200.00,200.00,25.00,250.00,250.00,'2018-11-30 12:36:15','2018-11-30 12:38:10',NULL),(924,'S',873,'variable3-1',875,672,70,100.00,100.00,25.00,125.00,125.00,'2018-11-30 12:50:29','2018-11-30 12:51:05',NULL),(925,'M',873,'variable3-2',875,673,71,150.00,150.00,25.00,187.50,187.50,'2018-11-30 12:50:29','2018-11-30 12:51:05',NULL),(926,'S',874,'variablewithstock-1',876,677,70,102.00,102.00,25.00,127.50,127.50,'2018-11-30 12:55:36','2018-11-30 12:56:17',NULL),(927,'M',874,'variablewithstock-2',876,678,71,150.00,150.00,25.00,187.50,187.50,'2018-11-30 12:55:36','2018-11-30 12:56:17',NULL),(928,'S',875,'testvariation10-1',877,680,70,150.00,150.00,25.00,187.50,187.50,'2018-11-30 13:01:42','2018-11-30 13:03:04',NULL),(929,'M',875,'testvariation10-2',877,681,71,140.00,140.00,25.00,175.00,175.00,'2018-11-30 13:01:42','2018-11-30 13:03:04',NULL),(930,'S',876,'testvariation10stock-1',878,683,70,120.00,120.00,25.00,150.00,150.00,'2018-11-30 13:04:07','2018-11-30 13:04:43',NULL),(931,'M',876,'testvariation10stock-2',878,684,71,150.00,150.00,25.00,187.50,187.50,'2018-11-30 13:04:07','2018-11-30 13:04:43',NULL),(932,'DUMMY',877,'AS0877',879,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-12-03 22:07:27','2018-12-03 22:07:27',NULL),(933,'DUMMY',879,'ProductProduct lite',881,NULL,NULL,100.00,110.00,25.00,125.00,137.50,'2018-12-05 23:24:06','2018-12-05 23:24:06',NULL),(934,'DUMMY',878,'ProductProduct lite',880,NULL,NULL,100.00,110.00,25.00,125.00,137.50,'2018-12-05 23:24:06','2018-12-05 23:24:06',NULL),(935,'DUMMY',880,'SKU (Leave blank to auto generate sku)',882,NULL,NULL,100.00,100.00,20.00,120.00,120.00,'2018-12-06 19:30:32','2018-12-06 19:42:59',NULL),(936,'DUMMY',881,'BCBXHD2D1123455',883,NULL,NULL,100.00,100.00,25.00,125.00,125.00,'2018-12-06 23:30:54','2018-12-06 23:30:54',NULL);
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `woocommerce_sync_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `woocommerce_sync_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `sync_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `operation_type` enum('created','updated') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `woocommerce_sync_logs` WRITE;
/*!40000 ALTER TABLE `woocommerce_sync_logs` DISABLE KEYS */;
INSERT INTO `woocommerce_sync_logs` VALUES (1,1,'categories','updated','[\"Accessories\",\"Athletic Clothing\"]',NULL,10,'2018-10-30 19:12:06','2018-10-30 19:12:06'),(2,1,'all_products','created','[\"AS0090\",\"AS0091\"]',NULL,10,'2018-10-30 19:19:16','2018-10-30 19:19:16'),(3,1,'orders','updated','[\"337\"]',NULL,10,'2018-10-23 22:27:08','2018-10-23 22:27:08'),(4,1,'all_products',NULL,'[]',NULL,10,'2018-10-23 18:33:39','2018-10-23 18:33:39'),(5,1,'orders','created','[\"342\",\"340\"]','[{\"error_type\":\"order_insuficient_product_qty\",\"order_number\":\"342\",\"msg\":\"ERROR: NOT ALLOWED: Mismatch between sold and purchase quantity. Product: Diary of a Wimpy Kid SKU: AS0022 Quantity: 2\"},{\"error_type\":\"order_product_not_found\",\"order_number\":\"340\",\"product\":\"Test Product - woo-tp\"}]',10,'2018-10-23 23:42:59','2018-10-23 23:42:59'),(6,1,'orders','updated','[\"341\"]',NULL,10,'2018-10-23 23:42:59','2018-10-23 23:42:59'),(7,1,'orders','created','[\"344\",\"342\",\"340\"]','[{\"error_type\":\"order_customer_empty\",\"order_number\":\"344\"},{\"error_type\":\"order_insuficient_product_qty\",\"order_number\":\"342\",\"msg\":\"ERROR: NOT ALLOWED: Mismatch between sold and purchase quantity. Product: Diary of a Wimpy Kid SKU: AS0022 Quantity: 2\"},{\"error_type\":\"order_product_not_found\",\"order_number\":\"340\",\"product\":\"Test Product SKU:woo-tp\"}]',10,'2018-10-30 00:25:53','2018-10-30 00:25:53'),(8,9,'categories',NULL,'[]',NULL,15,'2018-11-30 07:59:20','2018-11-30 07:59:20'),(9,9,'new_products','created','[\"0865\"]',NULL,15,'2018-11-30 07:59:24','2018-11-30 07:59:24'),(10,9,'categories',NULL,'[]',NULL,15,'2018-11-30 08:10:46','2018-11-30 08:10:46'),(11,9,'new_products','created','[\"0866\"]',NULL,15,'2018-11-30 08:10:50','2018-11-30 08:10:50'),(12,9,'categories',NULL,'[]',NULL,15,'2018-11-30 08:11:37','2018-11-30 08:11:37'),(13,9,'all_products','updated','[\"0865\",\"0866\"]',NULL,15,'2018-11-30 08:11:39','2018-11-30 08:11:39'),(14,9,'categories',NULL,'[]',NULL,15,'2018-11-30 08:14:13','2018-11-30 08:14:13'),(15,9,'new_products','created','[\"0868\"]',NULL,15,'2018-11-30 08:14:21','2018-11-30 08:14:21'),(16,9,'categories',NULL,'[]',NULL,15,'2018-11-30 08:15:36','2018-11-30 08:15:36'),(17,9,'all_products','updated','[\"0868\"]',NULL,15,'2018-11-30 08:15:39','2018-11-30 08:15:39'),(18,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:24:27','2018-11-30 12:24:27'),(19,9,'new_products','created','[\"same-sku\"]',NULL,15,'2018-11-30 12:24:28','2018-11-30 12:24:28'),(20,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:26:30','2018-11-30 12:26:30'),(21,9,'new_products','created','[\"price-sku\"]',NULL,15,'2018-11-30 12:26:30','2018-11-30 12:26:30'),(22,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:28:59','2018-11-30 12:28:59'),(23,9,'all_products','updated','[\"same-sku\",\"price-sku\"]',NULL,15,'2018-11-30 12:29:02','2018-11-30 12:29:02'),(24,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:34:50','2018-11-30 12:34:50'),(25,9,'new_products','created','[\"variable\"]',NULL,15,'2018-11-30 12:34:55','2018-11-30 12:34:55'),(26,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:36:33','2018-11-30 12:36:33'),(27,9,'new_products','created','[\"variable2\"]',NULL,15,'2018-11-30 12:36:38','2018-11-30 12:36:38'),(28,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:37:29','2018-11-30 12:37:29'),(29,9,'new_products',NULL,'[]',NULL,15,'2018-11-30 12:37:29','2018-11-30 12:37:29'),(30,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:37:51','2018-11-30 12:37:51'),(31,9,'all_products','updated','[\"variable\",\"variable2\"]',NULL,15,'2018-11-30 12:37:54','2018-11-30 12:37:54'),(32,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:50:49','2018-11-30 12:50:49'),(33,9,'new_products','created','[\"variable3\"]',NULL,15,'2018-11-30 12:50:54','2018-11-30 12:50:54'),(34,9,'categories',NULL,'[]',NULL,15,'2018-11-30 12:56:03','2018-11-30 12:56:03'),(35,9,'new_products','created','[\"variablewithstock\"]',NULL,15,'2018-11-30 12:56:08','2018-11-30 12:56:08'),(36,9,'categories',NULL,'[]',NULL,15,'2018-11-30 13:02:34','2018-11-30 13:02:34'),(37,9,'new_products','created','[\"testvariation10\"]',NULL,15,'2018-11-30 13:02:50','2018-11-30 13:02:50'),(38,9,'categories',NULL,'[]',NULL,15,'2018-11-30 13:04:28','2018-11-30 13:04:28'),(39,9,'new_products','created','[\"testvariation10stock\"]',NULL,15,'2018-11-30 13:04:36','2018-11-30 13:04:36');
/*!40000 ALTER TABLE `woocommerce_sync_logs` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

